/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.builtin;

import java.io.File;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Severity;
import org.netbeans.validation.api.Validator;
import org.openide.util.bundle.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileValidator
implements Validator<String> {
    private final Type type;

    public FileValidator(Type type) {
        this.type = type;
    }

    @Override
    public boolean validate(Problems problems, String compName, String model) {
        boolean ok;
        String key;
        File file = new File(model);
        switch (this.type) {
            case MUST_EXIST: {
                key = "FILE_DOES_NOT_EXIST";
                ok = file.exists();
                break;
            }
            case MUST_BE_DIRECTORY: {
                key = "FILE_IS_NOT_A_DIRECTORY";
                ok = file.isDirectory();
                break;
            }
            case MUST_BE_FILE: {
                key = "FILE_IS_NOT_A_FILE";
                ok = file.isFile();
                break;
            }
            case MUST_NOT_EXIST: {
                key = "FILE_EXISTS";
                ok = !file.exists();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (!ok) {
            String problem = NbBundle.getMessage(FileValidator.class, key, file.getName());
            problems.add(problem, Severity.FATAL);
        }
        return ok;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        MUST_EXIST,
        MUST_NOT_EXIST,
        MUST_BE_DIRECTORY,
        MUST_BE_FILE;

    }
}

