/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.builtin;

import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.openide.util.bundle.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonNegativeNumberValidator
implements Validator<String> {
    @Override
    public boolean validate(Problems problems, String compName, String text) {
        try {
            double d = Double.parseDouble(text);
            if (d < 0.0) {
                String problem = NbBundle.getMessage(NonNegativeNumberValidator.class, "ERR_NEGATIVE_NUMBER", compName);
                problems.add(problem);
                return false;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return true;
    }
}

