/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.jtable.rowheader;

import exenne.components.jtable.rowheader.JRowHeaderCellRenderer;
import exenne.components.jtable.rowheader.PhonyListSelectionModel;
import exenne.components.jtable.rowheader.RowHeaderModel;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JTable;

public class JTableRowHeader
extends JList {
    private static final int RIGHT_PADDING = 2;
    private static final int LEFT_PADDING = 2;
    private static final int NR_OF_CHARS = 4;

    public JTableRowHeader(JTable jtable, RowHeaderModel listModel) {
        this(jtable, listModel, 4);
    }

    public JTableRowHeader(JTable jtable, RowHeaderModel listModel, int cols) {
        this.setSelectionModel(new PhonyListSelectionModel());
        this.setFixedCellHeight(jtable.getRowHeight());
        jtable.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent e) {
                this.checkForHeightChange(e.getComponent());
            }

            public void componentMoved(ComponentEvent e) {
                this.checkForHeightChange(e.getComponent());
            }

            public void componentShown(ComponentEvent e) {
                this.checkForHeightChange(e.getComponent());
            }

            public void componentHidden(ComponentEvent e) {
            }

            private void checkForHeightChange(Component component) {
                JTable table = (JTable)component;
                int rowHeight = table.getRowHeight();
                if (rowHeight != JTableRowHeader.this.getFixedCellHeight()) {
                    JTableRowHeader.this.setFixedCellHeight(rowHeight);
                }
            }
        });
        int charSize = this.getFontMetrics(this.getFont()).charWidth('0');
        this.setFixedCellWidth(charSize * cols);
        this.setModel(listModel);
        this.setCellRenderer(new JRowHeaderCellRenderer());
        this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
    }
}

