/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.treetable.warningrowbar;

import exenne.components.jtable.rowheader.JTableRowHeader;
import exenne.components.treetable.warningrowbar.JSuggestionsPopup;
import exenne.components.treetable.warningrowbar.RunnableSuggestion;
import exenne.components.treetable.warningrowbar.WarningBarCellData;
import exenne.components.treetable.warningrowbar.WarningRowBarModel;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class JWarningRowBar
extends JTableRowHeader {
    private WarningRowBarModel warningBarModel;
    private MouseListener mouseListener = new MouseAdapter(){

        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            JList sourceList = (JList)e.getSource();
            int row = sourceList.locationToIndex(e.getPoint());
            if (row == -1) {
                return;
            }
            Rectangle cellBounds = sourceList.getCellBounds(row, row);
            int popupX = (int)(cellBounds.getX() + cellBounds.getWidth() + 5.0);
            int popupY = (int)(cellBounds.getY() + cellBounds.getHeight());
            WarningBarCellData cellData = (WarningBarCellData)sourceList.getModel().getElementAt(row);
            Vector<RunnableSuggestion> suggestions = cellData.getSuggestions();
            if (suggestions != null && !suggestions.isEmpty()) {
                JSuggestionsPopup suggestionsPopup = new JSuggestionsPopup(suggestions);
                suggestionsPopup.show(sourceList, popupX, popupY);
            }
        }

        public void mouseEntered(MouseEvent e) {
            super.mouseEntered(e);
            final JList sourceList = (JList)e.getSource();
            int row = sourceList.locationToIndex(e.getPoint());
            if (row == -1) {
                return;
            }
            Rectangle cellBounds = sourceList.getCellBounds(row, row);
            final int middleX = (int)(cellBounds.getX() + cellBounds.getWidth() / 2.0);
            final int middleY = (int)(cellBounds.getY() + cellBounds.getHeight() / 2.0);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MouseEvent moveEvent = new MouseEvent(sourceList, 0, 0L, 0, middleX, middleY, 0, false);
                    int initialDelay = ToolTipManager.sharedInstance().getInitialDelay();
                    ToolTipManager.sharedInstance().setInitialDelay(0);
                    ToolTipManager.sharedInstance().mouseMoved(moveEvent);
                    ToolTipManager.sharedInstance().setInitialDelay(initialDelay);
                }
            });
        }
    };

    public JWarningRowBar(JTable jtable, WarningRowBarModel listModel) {
        super(jtable, listModel);
        this.init(this.warningBarModel);
    }

    public JWarningRowBar(JTable jtable, WarningRowBarModel warningBarModel, int cols) {
        super(jtable, warningBarModel, cols);
        this.init(warningBarModel);
    }

    private void init(WarningRowBarModel warningBarModel) {
        this.warningBarModel = warningBarModel;
        this.addMouseListener(this.mouseListener);
    }
}

