/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.popup;

import exenne.components.popup.JUndoRedoIcons;
import exenne.components.transfer.TransferHandlerUtils;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class UndoRedoPopupManager {
    public static final String NAME_CUT = "Cut";
    public static final String NAME_COPY = "Copy";
    public static final String NAME_PASTE = "Paste";
    public static final String ACTION_CUT = "Cut".toLowerCase();
    public static final String ACTION_COPY = "Copy".toLowerCase();
    public static final String ACTION_PASTE = "Paste".toLowerCase();
    private static JUndoRedoIcons iconProvider = null;

    private UndoRedoPopupManager() {
    }

    private static JUndoRedoIcons getIconProvider() {
        if (iconProvider == null) {
            iconProvider = new JUndoRedoIcons();
        }
        return iconProvider;
    }

    public static Icon getCutIcon() {
        return UndoRedoPopupManager.getIconProvider().getIcon(0);
    }

    public static Icon getCopyIcon() {
        return UndoRedoPopupManager.getIconProvider().getIcon(1);
    }

    public static Icon getPasteIcon() {
        return UndoRedoPopupManager.getIconProvider().getIcon(2);
    }

    public static boolean isCutEnabled(JComponent targetComponent) {
        return TransferHandlerUtils.isCutEnabled(targetComponent);
    }

    public static boolean isCopyEnabled(JComponent targetComponent) {
        return TransferHandlerUtils.isCopyEnabled(targetComponent);
    }

    public static boolean isPasteEnabled(JComponent targetComponent) {
        return TransferHandlerUtils.isPasteEnabled(targetComponent);
    }

    public static boolean recognizeCommand(String cmd) {
        return ACTION_COPY.equals(cmd) || ACTION_PASTE.equals(cmd) || ACTION_CUT.equals(cmd);
    }

    public static void handleEvent(ActionEvent e, JComponent targetComponent) {
        String cmd = e.getActionCommand();
        if (ACTION_CUT.equals(cmd)) {
            ActionEvent copyEvent = new ActionEvent(targetComponent, 1, "cut");
            TransferHandler.getCutAction().actionPerformed(copyEvent);
        } else if (ACTION_COPY.equals(cmd)) {
            ActionEvent copyEvent = new ActionEvent(targetComponent, 1, "copy");
            TransferHandler.getCopyAction().actionPerformed(copyEvent);
        } else if (ACTION_PASTE.equals(cmd)) {
            ActionEvent pasteEvent = new ActionEvent(targetComponent, 1, "paste");
            TransferHandler.getPasteAction().actionPerformed(pasteEvent);
        }
    }
}

