/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.treetable;

import exenne.components.treetable.NodeRowModel;
import exenne.components.treetable.RowModel;
import exenne.components.treetable.TreetableModel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public final class ProxyTableModel
implements TableModel,
NodeRowModel {
    private List listeners = new ArrayList();
    private RowModel rowmodel;
    private TreetableModel outlineModel;

    public ProxyTableModel(RowModel rowmodel) {
        this.rowmodel = rowmodel;
    }

    void setOutlineModel(TreetableModel mdl) {
        this.outlineModel = mdl;
    }

    TreetableModel getOutlineModel() {
        return this.outlineModel;
    }

    RowModel getRowModel() {
        return this.rowmodel;
    }

    public Class getColumnClass(int columnIndex) {
        return this.rowmodel.getColumnClass(columnIndex);
    }

    public int getColumnCount() {
        return this.rowmodel.getColumnCount();
    }

    public String getColumnName(int columnIndex) {
        return this.rowmodel.getColumnName(columnIndex);
    }

    public int getRowCount() {
        return -1;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Object node = this.getNodeForRow(rowIndex);
        return this.rowmodel.getValueFor(node, columnIndex);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        Object node = this.getNodeForRow(rowIndex);
        return this.rowmodel.isCellEditable(node, columnIndex);
    }

    public synchronized void removeTableModelListener(TableModelListener l) {
        this.listeners.remove(l);
    }

    public synchronized void addTableModelListener(TableModelListener l) {
        this.listeners.add(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fire(TableModelEvent e) {
        TableModelListener[] l;
        ProxyTableModel proxyTableModel = this;
        synchronized (proxyTableModel) {
            l = new TableModelListener[this.listeners.size()];
            l = this.listeners.toArray(l);
        }
        for (int i = 0; i < l.length; ++i) {
            l[i].tableChanged(e);
        }
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Object node = this.getNodeForRow(rowIndex);
        boolean hasChanged = this.rowmodel.setValueFor(node, columnIndex, aValue);
        if (hasChanged) {
            TableModelEvent e = new TableModelEvent(this, rowIndex, rowIndex, columnIndex);
            this.fire(e);
        }
    }

    public Object getNodeForRow(int row) {
        return this.getOutlineModel().getValueAt(row, 0);
    }
}

