/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.treetable.cellrenderers;

import exenne.components.treetable.JHandleIcons;
import exenne.components.treetable.cellrenderers.AbstractTreetableCellRenderer;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.border.Border;

public class TreetableTooltipBorder
implements Border {
    private Insets insets = new Insets(0, 0, 0, 0);
    private Icon tootlipIcon;

    public TreetableTooltipBorder() {
        JHandleIcons iconProvider = new JHandleIcons();
        this.tootlipIcon = iconProvider.getIcon(2);
    }

    public Insets getBorderInsets(Component c) {
        AbstractTreetableCellRenderer ren = (AbstractTreetableCellRenderer)c;
        if (ren.hasToolTipText()) {
            int halignment = ren.getHorizontalAlignment();
            if (halignment == 4) {
                this.insets.left = this.tootlipIcon.getIconWidth();
                this.insets.top = 0;
                this.insets.right = 0;
                this.insets.bottom = 0;
            } else {
                this.insets.left = 0;
                this.insets.top = 0;
                this.insets.right = this.tootlipIcon.getIconWidth();
                this.insets.bottom = 0;
            }
        } else {
            this.insets.left = 0;
            this.insets.top = 0;
            this.insets.right = 0;
            this.insets.bottom = 0;
        }
        return this.insets;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2d = (Graphics2D)g;
        AbstractTreetableCellRenderer ren = (AbstractTreetableCellRenderer)c;
        if (ren.hasToolTipText()) {
            int iconY;
            int iconX;
            int halignment = ren.getHorizontalAlignment();
            if (halignment == 4) {
                iconX = 0;
                iconY = this.tootlipIcon.getIconHeight() < height ? height / 2 - this.tootlipIcon.getIconHeight() / 2 : 0;
            } else {
                iconX = width - this.tootlipIcon.getIconWidth();
                iconY = this.tootlipIcon.getIconHeight() < height ? height / 2 - this.tootlipIcon.getIconHeight() / 2 : 0;
            }
            g.setColor(Color.red);
            Composite composite = g2d.getComposite();
            AlphaComposite alpha = ren.isSelected() ? AlphaComposite.getInstance(3, 0.5f) : AlphaComposite.getInstance(3, 1.0f);
            try {
                g2d.setComposite(alpha);
                this.tootlipIcon.paintIcon(c, g, iconX, iconY);
            }
            finally {
                g2d.setComposite(composite);
            }
        }
    }
}

