/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.treetable.dnd;

import exenne.components.transfer.PackObjects;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class TransferPackObjects
implements Transferable {
    private Vector<DataFlavor> flavors;
    private Hashtable<String, PackObjects> hashtable;

    public TransferPackObjects() {
        this.initialize();
    }

    public TransferPackObjects(PackObjects pack) {
        this.initialize();
        this.addPackObjects(pack);
    }

    private void initialize() {
        this.flavors = new Vector();
        this.hashtable = new Hashtable();
    }

    public void addPackObjects(PackObjects pack) {
        DataFlavor dataFlavor = new DataFlavor(PackObjects.class, pack.getFlavorName());
        this.flavors.add(dataFlavor);
        String hashKey = dataFlavor.getHumanPresentableName();
        this.hashtable.put(hashKey, pack);
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] array = new DataFlavor[this.flavors.size()];
        return this.flavors.toArray(array);
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.flavors.contains(flavor);
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (this.isDataFlavorSupported(flavor)) {
            String hashKey = flavor.getHumanPresentableName();
            return this.hashtable.get(hashKey);
        }
        return null;
    }
}

