/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.gui.controller.genes;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;
import javax.swing.UIManager;
import ro.genomeartist.gui.controller.finalresult.IntervalMappingItem;
import ro.genomeartist.gui.controller.finalresult.IntervalMappingSet;
import ro.genomeartist.gui.controller.genes.GeneItem;
import ro.genomeartist.gui.controller.genes.GeneVector;
import ro.genomeartist.gui.custompaint.DrawingConstants;
import ro.genomeartist.gui.interfaces.ICanPaint;

public class GeneItemWrapper
implements ICanPaint {
    private IntervalMappingSet mappingParinte;
    private IntervalMappingItem interval;

    public GeneItemWrapper(IntervalMappingSet mappingParinte, IntervalMappingItem interval) {
        this.mappingParinte = mappingParinte;
        this.interval = interval;
    }

    public GeneItem getUpstreamGene() {
        if (this.interval.isComplement()) {
            return this.interval.getClosestDownstream();
        }
        return this.interval.getClosestUpstream();
    }

    public GeneItem getDownstreamGene() {
        if (this.interval.isComplement()) {
            return this.interval.getClosestUpstream();
        }
        return this.interval.getClosestDownstream();
    }

    public GeneVector getFullGeneVector() {
        GeneItem downstreamGene;
        GeneVector geneVector = new GeneVector();
        geneVector.addAll(this.interval.getInsideGenes());
        GeneItem upstreamGene = this.interval.getClosestUpstream();
        if (upstreamGene != null) {
            geneVector.add(upstreamGene);
        }
        if ((downstreamGene = this.interval.getClosestDownstream()) != null) {
            geneVector.add(downstreamGene);
        }
        return geneVector;
    }

    private int getRepresentativeInsideGeneIndex() {
        IntervalMappingItem itemStanga;
        GeneVector geneVector = this.interval.getInsideGenes();
        boolean isLeftSideBetter = false;
        boolean isRightSideBetter = false;
        if (this.mappingParinte.isEmpty()) {
            return 0;
        }
        int myIndex = this.mappingParinte.indexOf(this.interval);
        int vecinStanga = myIndex - 1;
        int vecinDreapta = myIndex + 1;
        if (vecinStanga >= 0 && (itemStanga = (IntervalMappingItem)this.mappingParinte.get(vecinStanga)).isTransposon() != this.interval.isTransposon()) {
            isLeftSideBetter = true;
        }
        if (vecinDreapta < this.mappingParinte.size() && (itemStanga = (IntervalMappingItem)this.mappingParinte.get(vecinDreapta)).isTransposon() != this.interval.isTransposon()) {
            isRightSideBetter = true;
        }
        if (isLeftSideBetter) {
            return 0;
        }
        if (isRightSideBetter) {
            return geneVector.size() - 1;
        }
        return 0;
    }

    public void paint(Graphics g, int width, int height, Color bgColor, Color fgColor) {
        this.mainPaintMethod(g, width, height, bgColor, fgColor, true, true);
    }

    public void alternativePaint(Graphics g, int width, int height, Color bgColor, Color fgColor) {
        this.mainPaintMethod(g, width, height, bgColor, fgColor, false, true);
    }

    public void paintImage(Graphics g, int width, int height, Color bgColor, Color fgColor) {
        this.mainPaintMethod(g, width, height, bgColor, fgColor, true, false);
    }

    private void mainPaintMethod(Graphics g, int width, int height, Color bgColor, Color fgColor, boolean paintAll, boolean isBackgroundFilled) {
        int loopCount;
        int loopStart;
        int localX;
        Color colorIntervalFill;
        Color colorIntervalBorder;
        Graphics2D g2d = (Graphics2D)g;
        int linieOffset = 5;
        int reservedTextWidth = 50;
        int reservedGap = 30;
        FontMetrics fontMetrics = g2d.getFontMetrics();
        int lineHeight = fontMetrics.getHeight();
        int lineWidth = 1;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int availableWidth = width;
        int availableHeight = height;
        Color lineColor = fgColor;
        Color colorGeneBorder = DrawingConstants.COLOR_GENE_BORDER;
        Color colorGeneFill = DrawingConstants.COLOR_GENE_FILL;
        if (this.interval.isTransposon()) {
            colorIntervalBorder = DrawingConstants.COLOR_TRANSPOSON_BORDER;
            colorIntervalFill = DrawingConstants.COLOR_TRANSPOSON_FILL;
        } else {
            colorIntervalBorder = DrawingConstants.COLOR_GENOM_BORDER;
            colorIntervalFill = DrawingConstants.COLOR_GENOM_FILL;
        }
        int reservedActiveWidth = width - 10 - 10 - 2 * reservedTextWidth - 2 * reservedGap;
        int actualActiveOffset = reservedTextWidth + reservedGap;
        double drawingRatio = (double)reservedActiveWidth / (double)this.interval.lengthInitialQuery;
        int actualIntervalWidth = (int)((double)this.interval.lengthQuery * drawingRatio);
        int actualIntervalOffset = (int)((double)this.interval.pozitieQuery * drawingRatio);
        actualIntervalOffset += actualActiveOffset;
        GeneVector insideGenes = this.interval.getInsideGenes();
        g2d.setStroke(new BasicStroke(lineWidth));
        g2d.setColor(bgColor);
        if (isBackgroundFilled) {
            g2d.fillRect(0, 0, width, height);
        }
        g2d.translate(0, 10);
        availableHeight -= 10;
        g2d.setColor(lineColor);
        int localY = 3 * lineHeight / 2;
        g2d.drawLine(linieOffset, localY, availableWidth - 2 * linieOffset, localY);
        int auxInt = lineHeight / 4;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.interval.isComplement()) {
            localX = linieOffset;
            g2d.drawLine(localX, localY, localX + auxInt, localY - auxInt);
            g2d.drawLine(localX, localY, localX + auxInt, localY + auxInt);
        } else {
            localX = availableWidth - linieOffset - auxInt;
            g2d.drawLine(localX, localY, localX - auxInt, localY - auxInt);
            g2d.drawLine(localX, localY, localX - auxInt, localY + auxInt);
        }
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
        g2d.translate(10, 0);
        availableWidth = availableWidth - 10 - 10;
        g2d.setColor(fgColor);
        GeneItem auxGene = this.interval.getClosestUpstream();
        String auxString = auxGene != null ? auxGene.getName() : "";
        g2d.drawString(auxString, 0, lineHeight - 2 * lineWidth);
        g2d.setColor(fgColor);
        auxGene = this.interval.getClosestDownstream();
        auxString = auxGene != null ? auxGene.getName() : "";
        localX = availableWidth - fontMetrics.stringWidth(auxString);
        g2d.drawString(auxString, localX, lineHeight - 2 * lineWidth);
        g2d.translate(actualIntervalOffset, 0);
        g2d.setColor(colorIntervalFill);
        g2d.fillRoundRect(0, lineWidth, actualIntervalWidth, lineHeight - lineWidth, 5, 5);
        g2d.setColor(colorIntervalBorder);
        g2d.drawRoundRect(0, lineWidth, actualIntervalWidth, lineHeight - lineWidth, 5, 5);
        g2d.translate(-actualIntervalOffset, 0);
        auxString = this.interval.getIntervalIndex() + 1 + "";
        auxInt = fontMetrics.stringWidth(auxString);
        localX = actualIntervalOffset + (actualIntervalWidth - auxInt) / 2;
        g2d.setColor(colorIntervalBorder);
        g2d.drawString(auxString, localX, lineHeight - 2 * lineWidth);
        g2d.translate(0, lineHeight);
        availableHeight -= lineHeight;
        if (paintAll) {
            loopStart = 0;
            loopCount = insideGenes.size();
        } else if (insideGenes.isEmpty()) {
            loopStart = 0;
            loopCount = 0;
        } else {
            loopStart = this.getRepresentativeInsideGeneIndex();
            loopCount = 1;
        }
        for (int i = loopStart; i < loopStart + loopCount; ++i) {
            int localWidth;
            int actualGeneWidth;
            int actualGeneOffset;
            auxGene = (GeneItem)insideGenes.elementAt(i);
            g2d.translate(0, lineHeight);
            availableHeight -= lineHeight;
            if (auxGene == null) continue;
            if (this.interval.isComplement()) {
                auxInt = this.interval.pozitieGenom + this.interval.lengthGenom - 1 - auxGene.locationEnd;
                actualGeneOffset = actualIntervalOffset + (int)((double)auxInt * drawingRatio);
                auxInt = auxGene.locationEnd - auxGene.locationStart + 1;
                actualGeneWidth = (int)((double)auxInt * drawingRatio);
            } else {
                auxInt = auxGene.locationStart - this.interval.pozitieGenom;
                actualGeneOffset = actualIntervalOffset + (int)((double)auxInt * drawingRatio);
                auxInt = auxGene.locationEnd - auxGene.locationStart + 1;
                actualGeneWidth = (int)((double)auxInt * drawingRatio);
            }
            boolean trimLeftHead = false;
            boolean trimRightHead = false;
            if (actualGeneOffset < 0) {
                trimLeftHead = true;
                actualGeneWidth += actualGeneOffset;
                actualGeneOffset = 0;
            }
            if (actualGeneOffset + actualGeneWidth > availableWidth) {
                trimRightHead = true;
                actualGeneWidth += availableWidth - actualGeneWidth;
            }
            g2d.setColor(colorGeneFill);
            g2d.fillRoundRect(actualGeneOffset, lineWidth, actualGeneWidth, lineHeight - 2 * lineWidth, 5, 5);
            g2d.setColor(colorGeneBorder);
            g2d.drawRoundRect(actualGeneOffset, lineWidth, actualGeneWidth, lineHeight - 2 * lineWidth, 5, 5);
            g2d.setColor(bgColor);
            Composite orig = g2d.getComposite();
            if (trimLeftHead) {
                localX = -lineWidth;
                localWidth = 5 + lineWidth;
                g2d.setComposite(AlphaComposite.Clear);
                g2d.fillRect(localX, 0, localWidth, lineHeight);
                g2d.setComposite(orig);
                if (isBackgroundFilled) {
                    g2d.fillRect(localX, 0, localWidth, lineHeight);
                }
                actualGeneOffset = 0;
                actualGeneWidth -= localWidth;
            }
            if (trimRightHead) {
                localX = availableWidth - 5;
                localWidth = 5 + lineWidth;
                g2d.setComposite(AlphaComposite.Clear);
                g2d.fillRect(localX, 0, localWidth, lineHeight);
                g2d.setComposite(orig);
                if (isBackgroundFilled) {
                    g2d.fillRect(localX, 0, localWidth, lineHeight);
                }
                actualGeneWidth -= localWidth;
            }
            auxString = auxGene.getName();
            auxInt = fontMetrics.stringWidth(auxString);
            localX = actualGeneOffset + (actualGeneWidth - auxInt) / 2;
            g2d.setColor(fgColor);
            g2d.drawString(auxString, localX, lineHeight - 3 * lineWidth);
        }
        if (!paintAll) {
            g2d.translate(0, lineHeight);
            availableHeight -= lineHeight;
            auxInt = insideGenes.size();
            if (auxInt > 1) {
                auxString = auxInt == 2 ? "and " + (auxInt - 1) + " other gene.." : "and " + (auxInt - 1) + " other genes..";
                auxInt = fontMetrics.stringWidth(auxString);
                localX = (availableWidth - auxInt) / 2;
                g2d.setColor(fgColor);
                g2d.drawString(auxString, localX, lineHeight - lineWidth);
            }
        }
        g2d.translate(0, availableHeight - height);
        g2d.setColor(colorIntervalBorder);
        float[] dash = new float[]{2.0f, 0.0f, 2.0f};
        g2d.setStroke(new BasicStroke(lineWidth, 0, 1, 1.0f, dash, 2.0f));
        g2d.translate(actualIntervalOffset, 0);
        g2d.drawLine(0, height, 0, 0);
        g2d.translate(actualIntervalWidth, 0);
        g2d.drawLine(0, height, 0, 0);
        g2d.translate(-actualIntervalOffset - actualIntervalWidth, 0);
        g2d.translate(-10, 0);
        g2d.setStroke(new BasicStroke(lineWidth));
    }

    public int getRecommendedHeight(JComponent component) {
        Font font = UIManager.getDefaults().getFont("Table.font");
        int lineHeight = component.getFontMetrics(font).getHeight();
        int recommendedSize = 20 + 3 * lineHeight + this.interval.getInsideGenes().size() * lineHeight;
        return recommendedSize;
    }

    public int getRecommendedWidth(JComponent component) {
        return 300;
    }

    public int getAltRecommendedHeight(JComponent component) {
        Font font = UIManager.getDefaults().getFont("Table.font");
        int lineHeight = component.getFontMetrics(font).getHeight();
        int recommendedSize = 20 + 4 * lineHeight;
        return recommendedSize;
    }

    public int getAltRecommendedWidth(JComponent component) {
        return 300;
    }

    public int getImageHeight(JComponent component) {
        return this.getRecommendedHeight(component);
    }

    public int getImageWidth(JComponent component) {
        return 800;
    }
}

