/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.components.jtable.rowheader.implementation;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.border.Border;
import ro.genomeartist.components.jtable.rowheader.RowAnnotation;
import ro.genomeartist.components.jtable.rowheader.RowHeaderCellData;
import ro.genomeartist.components.jtable.rowheader.implementation.MultipleAnnotationArrowBorder;

public class JRowHeaderCellRenderer
extends DefaultListCellRenderer {
    private static final int RIGHT_PADDING = 2;
    private static final int LEFT_PADDING = 2;
    private static final Border STANDARD_BORDER = BorderFactory.createEmptyBorder(0, 2, 0, 2);
    private static final Border MULTIPLE_ANNOTATIONS_BORDER = new MultipleAnnotationArrowBorder();

    public JRowHeaderCellRenderer() {
        this.setBorder(null);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        this.setHorizontalAlignment(4);
        if (value instanceof RowHeaderCellData) {
            RowHeaderCellData listCellData = (RowHeaderCellData)value;
            int annotationsCount = listCellData.getRowAnnotationCount();
            if (annotationsCount > 1) {
                this.setBorder(MULTIPLE_ANNOTATIONS_BORDER);
            } else {
                this.setBorder(STANDARD_BORDER);
            }
            RowAnnotation currentAnnotation = listCellData.getCurrentAnnotation();
            if (currentAnnotation != null) {
                Icon icon = currentAnnotation.getIcon();
                if (icon != null) {
                    this.setText(null);
                    this.setIcon(icon);
                    this.setToolTipText(currentAnnotation.getTooltipText());
                } else {
                    this.setText(listCellData.getText());
                    this.setIcon(null);
                    this.setToolTipText(currentAnnotation.getTooltipText());
                }
            } else {
                this.setText(listCellData.getText());
                this.setToolTipText(null);
            }
            Color bgColor = listCellData.getBackgroundColor();
            if (bgColor == null) {
                bgColor = list.getBackground();
            }
            this.setBackground(bgColor);
            this.setForeground(listCellData.getForegroundColor());
        } else {
            this.setBorder(STANDARD_BORDER);
            this.setText(value.toString());
        }
        return this;
    }
}

