/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.components.popup;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class JConfigurableMenu
extends JMenu {
    public ActionListener myPopupListener = null;
    Hashtable<String, Component> items;

    public JConfigurableMenu(String name, Icon icon, ActionListener popupListener) {
        super(name);
        this.setIcon(icon);
        this.items = new Hashtable();
        this.myPopupListener = popupListener;
    }

    public JConfigurableMenu(String name, ActionListener popupListener) {
        this(name, null, popupListener);
    }

    public void addItem(String itemName) {
        this.addItem(itemName, null);
    }

    public void addItem(String itemName, Icon icon) {
        this.addItem(itemName, icon, -1, null);
    }

    public void addItem(String itemName, Icon icon, int mnemonic) {
        this.addItem(itemName, icon, mnemonic, null);
    }

    public void addItem(String itemName, String actionName, Icon icon, int mnemonic) {
        this.addItem(itemName, actionName, icon, mnemonic, null);
    }

    public void addItem(String itemName, Icon icon, KeyStroke accelerator) {
        this.addItem(itemName, icon, -1, accelerator);
    }

    public void addItem(String itemName, String actionName, Icon icon, KeyStroke accelerator) {
        this.addItem(itemName, actionName, icon, -1, accelerator);
    }

    public void addItem(String itemName, int mnemonic, KeyStroke accelerator) {
        this.addItem(itemName, null, mnemonic, accelerator);
    }

    public void addItem(String itemName, Icon icon, int mnemonic, KeyStroke accelerator) {
        this.addItem(itemName, itemName.toLowerCase(), icon, mnemonic, accelerator);
    }

    public void addItem(String itemName, String actionName, Icon icon, int mnemonic, KeyStroke accelerator) {
        JMenuItem menuItem = new JMenuItem(itemName);
        if (icon != null) {
            menuItem.setIcon(icon);
        }
        menuItem.setActionCommand(actionName);
        menuItem.addActionListener(this.myPopupListener);
        if (mnemonic >= 0) {
            menuItem.setMnemonic(mnemonic);
        }
        if (accelerator != null) {
            menuItem.setAccelerator(accelerator);
        }
        this.items.put(itemName, menuItem);
        this.add(menuItem);
    }

    public void setItemEnabled(String itemName) {
        Component menuItem = this.items.get(itemName);
        if (menuItem != null) {
            menuItem.setEnabled(true);
        }
    }

    public void setItemDisabled(String itemName) {
        Component menuItem = this.items.get(itemName);
        if (menuItem != null) {
            menuItem.setEnabled(false);
        }
    }

    public void setItemVisible(String itemName) {
        Component menuItem = this.items.get(itemName);
        if (menuItem != null) {
            menuItem.setVisible(true);
        }
    }

    public void setItemInvisible(String itemName) {
        Component menuItem = this.items.get(itemName);
        if (menuItem != null) {
            menuItem.setVisible(false);
        }
    }
}

