/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.components.propertiespanel.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.math.BigDecimal;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import ro.genomeartist.components.passwordfield.fixedwidth.JFixedWidthPasswordField;
import ro.genomeartist.components.propertiespanel.IEditorChangeListener;
import ro.genomeartist.components.propertiespanel.IPropertiesEditor;
import ro.genomeartist.components.propertiespanel.undecided.UndecidedBigDecimal;
import ro.genomeartist.components.propertiespanel.undecided.UndecidedInteger;
import ro.genomeartist.components.utils.NumberUtils;

public class JPasswordFieldPropertiesEditor
extends JPanel
implements IPropertiesEditor,
DocumentListener {
    private JPasswordField passwordField;
    private JLabel endingLabel;
    private Vector<IEditorChangeListener> editorChangeListeners;

    public JPasswordFieldPropertiesEditor(int width) {
        this(width, "");
    }

    public JPasswordFieldPropertiesEditor(int width, String endingText, int labelWidth) {
        this.passwordField = new JFixedWidthPasswordField(width);
        this.endingLabel = new JLabel(endingText);
        this.endingLabel.setPreferredSize(new Dimension(labelWidth, 0));
        this.initialize();
    }

    public JPasswordFieldPropertiesEditor(int width, String endingText) {
        this.passwordField = new JFixedWidthPasswordField(width);
        this.endingLabel = new JLabel(endingText);
        this.initialize();
    }

    public JPasswordFieldPropertiesEditor(String endingText, int labelWidth) {
        this.passwordField = new JFixedWidthPasswordField();
        this.endingLabel = new JLabel(endingText);
        this.endingLabel.setPreferredSize(new Dimension(labelWidth, 0));
        this.initialize();
    }

    public JPasswordFieldPropertiesEditor(String endingText) {
        this.passwordField = new JFixedWidthPasswordField();
        this.endingLabel = new JLabel(endingText);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.passwordField, "Center");
        this.add((Component)this.endingLabel, "East");
        this.endingLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        this.passwordField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                JPasswordFieldPropertiesEditor.this.passwordField.selectAll();
            }
        });
        this.editorChangeListeners = new Vector();
        this.passwordField.getDocument().addDocumentListener(this);
    }

    public String getEndingText() {
        return this.endingLabel.getText();
    }

    public void setEndingText(String endingText) {
        this.endingLabel.setText(endingText);
    }

    @Override
    public JComponent getContainerComponent() {
        return this;
    }

    @Override
    public JComponent getEditorComponent() {
        return this.passwordField;
    }

    @Override
    public void setEditorName(String name) {
        this.setName(name);
        this.passwordField.setName(name);
    }

    @Override
    public void setValue(Class objectClass, Object renderedObject) {
        if (String.class == objectClass) {
            String auxString = (String)renderedObject;
            this.passwordField.setText(auxString);
            this.passwordField.setHorizontalAlignment(2);
        } else if (Integer.class == objectClass) {
            Integer auxInteger = (Integer)renderedObject;
            this.passwordField.setText(auxInteger.toString());
            this.passwordField.setHorizontalAlignment(4);
        } else if (BigDecimal.class == objectClass) {
            BigDecimal auxBigDecimal = (BigDecimal)renderedObject;
            auxBigDecimal = auxBigDecimal.stripTrailingZeros();
            this.passwordField.setText(auxBigDecimal.toPlainString());
            this.passwordField.setHorizontalAlignment(4);
        } else if (UndecidedBigDecimal.class == objectClass) {
            UndecidedBigDecimal auxUndecidedBigDecimal = (UndecidedBigDecimal)renderedObject;
            this.passwordField.setText(auxUndecidedBigDecimal.toString());
            this.passwordField.setHorizontalAlignment(4);
        } else if (UndecidedInteger.class == objectClass) {
            UndecidedInteger auxUndecidedInteger = (UndecidedInteger)renderedObject;
            this.passwordField.setText(auxUndecidedInteger.toString());
            this.passwordField.setHorizontalAlignment(4);
        } else {
            throw new UnsupportedOperationException(objectClass + " not supported in JTextField");
        }
    }

    @Override
    public Object getValue(Class objectClass) {
        if (String.class == objectClass) {
            String auxString = this.passwordField.getText();
            return auxString;
        }
        if (Integer.class == objectClass) {
            String auxString = this.passwordField.getText();
            Integer auxInteger = NumberUtils.isValidInteger(auxString) ? Integer.valueOf(auxString) : Integer.valueOf(0);
            return auxInteger;
        }
        if (BigDecimal.class == objectClass) {
            String auxString = this.passwordField.getText();
            BigDecimal auxBigDecimal = NumberUtils.isValidNumber(auxString) ? new BigDecimal(auxString) : BigDecimal.ZERO;
            return auxBigDecimal;
        }
        if (UndecidedBigDecimal.class == objectClass) {
            String auxString = this.passwordField.getText();
            UndecidedBigDecimal auxUndecidedBigDecimal = new UndecidedBigDecimal(auxString);
            return auxUndecidedBigDecimal;
        }
        if (UndecidedBigDecimal.class == objectClass) {
            String auxString = this.passwordField.getText();
            UndecidedInteger auxUndecidedInteger = new UndecidedInteger(auxString);
            return auxUndecidedInteger;
        }
        throw new UnsupportedOperationException(objectClass + " not supported in JTextField");
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.passwordField.setEnabled(enabled);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.notifyAllListeners();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.notifyAllListeners();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.notifyAllListeners();
    }

    private void notifyAllListeners() {
        for (IEditorChangeListener iEditorChangeListener : this.editorChangeListeners) {
            iEditorChangeListener.fireValueChanged();
        }
    }

    @Override
    public void addEditorChangeListener(IEditorChangeListener listener) {
        this.editorChangeListeners.add(listener);
    }

    @Override
    public void removeEditorChangeListener(IEditorChangeListener listener) {
        this.editorChangeListeners.remove(listener);
    }
}

