/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.coloredtable.filter;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import ro.genomeartist.coloredtable.filter.JFilterIcons;
import ro.genomeartist.coloredtable.filter.RegexRowFilter;
import ro.genomeartist.components.textfield.fixedwidth.JFixedWidthTextField;
import ro.genomeartist.components.toolbar.JConfiguredToolbar;
import ro.genomeartist.components.toolbar.JToolbarButton;

public class JRegexFilterPanel
extends JConfiguredToolbar
implements ActionListener {
    private TableRowSorter<TableModel> tableSorter;
    private int[] indices;
    private static final String ACTION_SEARCH = "search";
    private static final String ACTION_RESET_FILTRU = "reset_filtru";
    private JLabel labelFiltru;
    private JTextField textfieldFiltru;
    private JButton buttonResetFiltru;
    private DocumentListener filtruDocumentListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.filterRows();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.filterRows();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.filterRows();
        }

        private void filterRows() {
            String text = JRegexFilterPanel.this.textfieldFiltru.getText();
            if (text.length() == 0) {
                JRegexFilterPanel.this.tableSorter.setRowFilter(null);
            } else {
                try {
                    JRegexFilterPanel.this.tableSorter.setRowFilter(RegexRowFilter.getRegexFilter(text, JRegexFilterPanel.this.indices));
                }
                catch (PatternSyntaxException pse) {
                    System.err.println("Bad regex pattern");
                }
            }
        }
    };

    private JRegexFilterPanel(TableRowSorter<TableModel> tableSorter, int[] indices) {
        this.tableSorter = tableSorter;
        this.indices = indices;
        this.labelFiltru = new JLabel("Filtru ");
        this.add(Box.createHorizontalStrut(15));
        this.add(this.labelFiltru);
        this.add(Box.createHorizontalStrut(5));
        this.textfieldFiltru = new JFixedWidthTextField(200);
        this.textfieldFiltru.getDocument().addDocumentListener(this.filtruDocumentListener);
        this.add(this.textfieldFiltru);
        this.buttonResetFiltru = new JToolbarButton();
        this.buttonResetFiltru.setActionCommand(ACTION_RESET_FILTRU);
        this.buttonResetFiltru.setToolTipText("Reseteaza filtru");
        this.buttonResetFiltru.addActionListener(this);
        this.buttonResetFiltru.setIcon(JFilterIcons.RESET.getIcon());
        this.add(Box.createHorizontalStrut(5));
        this.add(this.buttonResetFiltru);
        this.initKeyBindings();
    }

    public static JRegexFilterPanel getRegexFilterPanel(TableRowSorter<TableModel> tableSorter, int ... indices) {
        return new JRegexFilterPanel(tableSorter, indices);
    }

    private void initKeyBindings() {
        ActionMap map = this.textfieldFiltru.getActionMap();
        AbstractAction actionSearch = new AbstractAction(ACTION_SEARCH){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        map.put(actionSearch.getValue("Name"), actionSearch);
        InputMap imap = this.textfieldFiltru.getInputMap();
        imap.put(KeyStroke.getKeyStroke("ENTER"), actionSearch.getValue("Name"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (ACTION_RESET_FILTRU.equals(cmd)) {
            this.fireActionResetFiltru();
        }
    }

    public void fireActionResetFiltru() {
        this.textfieldFiltru.setText("");
    }
}

