/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.popup;

import exenne.components.popup.CopyPastePopupManager;
import exenne.components.popup.JConfigurablePopup;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class JCopyPastePopup {
    private JComponent targetComponent = null;
    private JConfigurablePopup configurablePopup;
    ActionListener popupListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (CopyPastePopupManager.recognizeCommand(cmd)) {
                CopyPastePopupManager.handleEvent(e, JCopyPastePopup.this.targetComponent);
            }
        }
    };
    MouseListener popupTrigger = new MouseListener(){

        public void mouseClicked(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        private void syncronizePopup() {
            if (CopyPastePopupManager.isCutEnabled(JCopyPastePopup.this.targetComponent)) {
                JCopyPastePopup.this.configurablePopup.setItemEnabled("Cut");
            } else {
                JCopyPastePopup.this.configurablePopup.setItemDisabled("Cut");
            }
            if (CopyPastePopupManager.isCopyEnabled(JCopyPastePopup.this.targetComponent)) {
                JCopyPastePopup.this.configurablePopup.setItemEnabled("Copy");
            } else {
                JCopyPastePopup.this.configurablePopup.setItemDisabled("Copy");
            }
            if (CopyPastePopupManager.isPasteEnabled(JCopyPastePopup.this.targetComponent)) {
                JCopyPastePopup.this.configurablePopup.setItemEnabled("Paste");
            } else {
                JCopyPastePopup.this.configurablePopup.setItemDisabled("Paste");
            }
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                if (e.getComponent() instanceof JComponent) {
                    JCopyPastePopup.this.targetComponent = (JComponent)e.getComponent();
                }
                this.syncronizePopup();
                JCopyPastePopup.this.configurablePopup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    };

    public JCopyPastePopup() {
        this.configurablePopup = this.createPopup();
    }

    private JConfigurablePopup createPopup() {
        JConfigurablePopup popup = new JConfigurablePopup(this.popupListener);
        popup.addItem("Cut", CopyPastePopupManager.getCutIcon(), KeyStroke.getKeyStroke("ctrl X"));
        popup.addItem("Copy", CopyPastePopupManager.getCopyIcon(), KeyStroke.getKeyStroke("ctrl C"));
        popup.addItem("Paste", CopyPastePopupManager.getPasteIcon(), KeyStroke.getKeyStroke("ctrl V"));
        return popup;
    }

    public MouseListener getPopupTrigger() {
        return this.popupTrigger;
    }
}

