/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.propertiespanel.editors;

import exenne.components.propertiespanel.IEditorChangeListener;
import exenne.components.propertiespanel.IPropertiesEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class JComboBoxPropertiesEditor
extends JPanel
implements IPropertiesEditor,
ActionListener {
    private JComboBox comboBox;
    private Vector<IEditorChangeListener> editorChangeListeners;

    public JComboBoxPropertiesEditor(JComboBox comboBox) {
        this.comboBox = comboBox;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.comboBox, "Center");
        this.editorChangeListeners = new Vector();
        this.comboBox.addActionListener(this);
    }

    public void setEnabled(boolean enabled) {
        this.comboBox.setEnabled(enabled);
    }

    public JComponent getContainerComponent() {
        return this;
    }

    public JComponent getEditorComponent() {
        return this.comboBox;
    }

    public void setEditorName(String name) {
        this.setName(name);
        this.comboBox.setName(name);
    }

    public void setValue(Class objectClass, Object renderedObject) {
        this.comboBox.setSelectedItem(renderedObject);
    }

    public Object getValue(Class objectClass) {
        return this.comboBox.getSelectedItem();
    }

    public void actionPerformed(ActionEvent e) {
        for (IEditorChangeListener iEditorChangeListener : this.editorChangeListeners) {
            iEditorChangeListener.fireValueChanged();
        }
    }

    public void addEditorChangeListener(IEditorChangeListener listener) {
        this.editorChangeListeners.add(listener);
    }

    public void removeEditorChangeListener(IEditorChangeListener listener) {
        this.editorChangeListeners.remove(listener);
    }
}

