/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.textfield.validator;

import exenne.components.textfield.validator.ColorizingBorder;
import exenne.components.textfield.validator.IValidateString;
import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class JValidatorTextfield
extends JTextField
implements DocumentListener {
    private boolean isValid;
    private IValidateString validator;
    private Border originalBorder;
    private Border problemBorder;
    private static final Color ERROR_COLOR = new Color(255, 0, 0);

    public JValidatorTextfield() {
        this(null, null);
    }

    public JValidatorTextfield(Border originalBorder) {
        this(null, originalBorder);
    }

    public JValidatorTextfield(IValidateString validator, Border originalBorder) {
        this.getDocument().addDocumentListener(this);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                super.focusGained(e);
                JValidatorTextfield.this.selectAll();
            }
        });
        this.isValid = true;
        this.validator = validator;
        if (originalBorder != null) {
            this.setBorder(originalBorder);
        }
        this.originalBorder = this.getBorder();
        this.problemBorder = new ColorizingBorder(originalBorder, ERROR_COLOR);
    }

    public IValidateString getValidator() {
        return this.validator;
    }

    public void setValidator(IValidateString validator) {
        this.validator = validator;
    }

    public boolean isValidValue() {
        return this.isValid;
    }

    public void insertUpdate(DocumentEvent e) {
        this.validateValue();
    }

    public void removeUpdate(DocumentEvent e) {
        this.validateValue();
    }

    public void changedUpdate(DocumentEvent e) {
        this.validateValue();
    }

    private void validateValue() {
        String text;
        boolean localIsValid;
        if (this.validator != null && this.isValid != (localIsValid = this.validator.validate(text = this.getText()))) {
            this.isValid = localIsValid;
            if (this.isValid) {
                this.setBorder(this.originalBorder);
            } else {
                this.setBorder(this.problemBorder);
            }
        }
    }
}

