/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.tree.expansion;

import exenne.components.tree.expansion.ExpandableComponent;
import exenne.components.tree.expansion.NodeExpansionValidator;
import exenne.components.tree.expansion.validators.ForbidenClassesValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeNodesUtils {
    public static DefaultMutableTreeNode findObjectInTree(DefaultMutableTreeNode node, Object object) {
        Enumeration<TreeNode> enumeration = node.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode nodeItem = (DefaultMutableTreeNode)enumeration.nextElement();
            Object userObject = nodeItem.getUserObject();
            if (object == null || !object.equals(userObject)) continue;
            return nodeItem;
        }
        return null;
    }

    public static Vector<DefaultMutableTreeNode> findObjectsInTree(DefaultMutableTreeNode node, Vector<Object> objects) {
        Vector<DefaultMutableTreeNode> foundNodes = new Vector<DefaultMutableTreeNode>();
        Enumeration<TreeNode> enumeration = node.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode nodeItem = (DefaultMutableTreeNode)enumeration.nextElement();
            Object userObject = nodeItem.getUserObject();
            if (!objects.contains(userObject)) continue;
            foundNodes.add(nodeItem);
        }
        return foundNodes;
    }

    public static void expandAll(ExpandableComponent expandableComponent) {
        TreeNode root = expandableComponent.getRootNode();
        TreeNodesUtils.expandAll(expandableComponent, new TreePath(root));
    }

    public static void expandAll(ExpandableComponent expandableComponent, DefaultMutableTreeNode root) {
        TreeNodesUtils.expandAll(expandableComponent, new TreePath(root));
    }

    private static void expandAll(ExpandableComponent expandableComponent, TreePath parent) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                if (n.isLeaf()) continue;
                TreePath path = parent.pathByAddingChild(n);
                TreeNodesUtils.expandAll(expandableComponent, path);
            }
        }
        expandableComponent.expandPath(parent);
    }

    public static void collapseAll(ExpandableComponent expandableComponent) {
        TreeNode root = expandableComponent.getRootNode();
        TreeNodesUtils.collapseAll(expandableComponent, new TreePath(root));
    }

    public static void collapseAll(ExpandableComponent expandableComponent, DefaultMutableTreeNode root) {
        TreeNodesUtils.collapseAll(expandableComponent, new TreePath(root));
    }

    private static void collapseAll(ExpandableComponent expandableComponent, TreePath parent) {
        boolean isRoot;
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                if (n.isLeaf()) continue;
                TreePath path = parent.pathByAddingChild(n);
                TreeNodesUtils.collapseAll(expandableComponent, path);
            }
        }
        if (!(isRoot = ((DefaultMutableTreeNode)parent.getLastPathComponent()).isRoot())) {
            expandableComponent.collapsePath(parent);
        }
    }

    public static void expandAllButClasses(ExpandableComponent expandableComponent, Class ... forbidenClasses) {
        TreeNode root = expandableComponent.getRootNode();
        TreeNodesUtils.expandAllButClasses(expandableComponent, new TreePath(root), new Class[0]);
    }

    public static void expandAllButClasses(ExpandableComponent expandableComponent, TreePath parent, Class ... forbidenClasses) {
        List<Class> forbidenClassesList = Arrays.asList(forbidenClasses);
        ForbidenClassesValidator validator = new ForbidenClassesValidator(forbidenClassesList);
        TreeNodesUtils.expandAllWithValidation(expandableComponent, parent, validator);
    }

    public static void expandAllWithValidation(ExpandableComponent expandableComponent, NodeExpansionValidator validator) {
        TreeNode root = expandableComponent.getRootNode();
        TreeNodesUtils.expandAllWithValidation(expandableComponent, new TreePath(root), validator);
    }

    public static void expandAllWithValidation(ExpandableComponent expandableComponent, TreePath parent, NodeExpansionValidator validator) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)e.nextElement();
                Object object = n.getUserObject();
                if (n.isLeaf() || !validator.validate(object)) continue;
                TreePath path = parent.pathByAddingChild(n);
                TreeNodesUtils.expandAllWithValidation(expandableComponent, path, validator);
            }
        }
        expandableComponent.expandPath(parent);
    }

    public static void expandToLevel(ExpandableComponent expandableComponent, int level) {
        TreeNode root = expandableComponent.getRootNode();
        TreeNodesUtils.expandToLevel(expandableComponent, new TreePath(root), level);
    }

    public static void expandToLevel(ExpandableComponent expandableComponent, TreePath parent, int level) {
        TreeNodesUtils.expandToLevel(expandableComponent, parent, level, 1);
    }

    private static void expandToLevel(ExpandableComponent expandableComponent, TreePath parent, int level, int currentLevel) {
        TreeNode node;
        if (currentLevel < level && (node = (TreeNode)parent.getLastPathComponent()).getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                if (n.isLeaf()) continue;
                TreePath path = parent.pathByAddingChild(n);
                TreeNodesUtils.expandToLevel(expandableComponent, path, level, currentLevel + 1);
            }
        }
        expandableComponent.expandPath(parent);
    }

    public static void expandToOptimalCoverage(ExpandableComponent expandableComponent, int nodeLimit) {
        TreeNode root = expandableComponent.getRootNode();
        TreeNodesUtils.expandToOptimalCoverage(expandableComponent, new TreePath(root), nodeLimit);
    }

    public static void expandToOptimalCoverage(ExpandableComponent expandableComponent, TreePath parent, int nodeLimit) {
        TreeNode parentNode = (TreeNode)parent.getPathComponent(0);
        ArrayList<Integer> nodeCountByLevel = TreeNodesUtils.getNodeCountByLevel(parentNode);
        int prefferedLevel = 0;
        int currentNodes = 0;
        for (int i = 0; i < nodeCountByLevel.size(); ++i) {
            Integer value = nodeCountByLevel.get(i);
            if ((currentNodes += value.intValue()) >= nodeLimit) continue;
            prefferedLevel = i;
        }
        TreeNodesUtils.expandToLevel(expandableComponent, parent, prefferedLevel);
    }

    private static ArrayList<Integer> getNodeCountByLevel(TreeNode parentNode) {
        ArrayList<Integer> levelCount = new ArrayList<Integer>();
        ArrayList currentNodes = new ArrayList();
        ArrayList<TreeNode> nextNodes = new ArrayList<TreeNode>();
        if (parentNode == null) {
            return levelCount;
        }
        int currentLevel = 0;
        nextNodes.add(parentNode);
        int childNumber = nextNodes.size();
        levelCount.add(currentLevel, childNumber);
        ++currentLevel;
        while (childNumber != 0) {
            ArrayList auxList = currentNodes;
            currentNodes = nextNodes;
            nextNodes = auxList;
            nextNodes.clear();
            for (TreeNode nodeItem : currentNodes) {
                if (nodeItem.getChildCount() < 0) continue;
                Enumeration<? extends TreeNode> e = nodeItem.children();
                while (e.hasMoreElements()) {
                    TreeNode nodeChildren = e.nextElement();
                    nextNodes.add(nodeChildren);
                }
            }
            childNumber = nextNodes.size();
            if (childNumber <= 0) continue;
            levelCount.add(currentLevel, childNumber);
            ++currentLevel;
        }
        return levelCount;
    }

    public static void main(String[] args) {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("rootNode");
        DefaultMutableTreeNode child1 = new DefaultMutableTreeNode("child1");
        DefaultMutableTreeNode child1_1 = new DefaultMutableTreeNode("child1_1");
        DefaultMutableTreeNode child1_2 = new DefaultMutableTreeNode("child1_2");
        DefaultMutableTreeNode child1_3 = new DefaultMutableTreeNode("child1_3");
        DefaultMutableTreeNode child2 = new DefaultMutableTreeNode("child2");
        DefaultMutableTreeNode child2_1 = new DefaultMutableTreeNode("child2_1");
        DefaultMutableTreeNode child3 = new DefaultMutableTreeNode("child3");
        DefaultMutableTreeNode child3_1 = new DefaultMutableTreeNode("child3_1");
        DefaultMutableTreeNode child3_2 = new DefaultMutableTreeNode("child3_2");
        rootNode.add(child1);
        child1.add(child1_1);
        child1.add(child1_2);
        child1.add(child1_3);
        rootNode.add(child2);
        child2.add(child2_1);
        rootNode.add(child3);
        child3.add(child3_1);
        child3.add(child3_2);
        ArrayList<Integer> nodeCountByLevel = TreeNodesUtils.getNodeCountByLevel(rootNode);
        System.out.println(nodeCountByLevel);
    }
}

