/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.treetable.dnd;

import exenne.components.transfer.PackObjects;
import exenne.components.treetable.Treetable;
import exenne.components.treetable.dnd.TransferDataProvider;
import exenne.components.treetable.dnd.TransferPackObjects;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

public class TreetableTransferHandler
extends TransferHandler {
    protected TransferDataProvider dataProvider;
    protected PackObjects localPack;

    public TreetableTransferHandler(TransferDataProvider dataProvider) {
        this.dataProvider = dataProvider;
        this.localPack = null;
    }

    public int getSourceActions(JComponent comp) {
        Treetable treetable = this.dataProvider.getTreetable();
        if (treetable.equals(comp)) {
            return this.dataProvider.getSourceActions();
        }
        return 0;
    }

    public Transferable createTransferable(JComponent comp) {
        Treetable treetable = this.dataProvider.getTreetable();
        if (treetable.equals(comp)) {
            PackObjects pack = this.dataProvider.createPack();
            if (pack == null) {
                return null;
            }
            pack.setOwner(treetable);
            this.localPack = pack;
            if (pack.size() == 0) {
                return null;
            }
            return new TransferPackObjects(pack);
        }
        return null;
    }

    public void exportDone(JComponent comp, Transferable trans, int action) {
        Treetable treetable = this.dataProvider.getTreetable();
        if (!treetable.equals(comp)) {
            return;
        }
        try {
            if (action != 2) {
                return;
            }
            if (!this.dataProvider.isInhibitExport()) {
                DataFlavor dataFlavor = new DataFlavor(PackObjects.class, this.dataProvider.getFlavourName());
                PackObjects packObjects = (PackObjects)trans.getTransferData(dataFlavor);
                if (packObjects.isOwner(treetable)) {
                    packObjects = this.localPack;
                }
                this.dataProvider.exportDone(packObjects);
            }
        }
        catch (UnsupportedFlavorException ex) {
            ex.printStackTrace();
            System.err.println("Unsupported Flavor");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.err.println("Eroare la operatii IO (Serializabil)");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println("Unusual exception in DnD");
        }
    }

    public boolean canImport(TransferHandler.TransferSupport support) {
        Component comp;
        Treetable treetable = this.dataProvider.getTreetable();
        if (!treetable.equals(comp = support.getComponent())) {
            return false;
        }
        DefaultTreeModel treeModel = (DefaultTreeModel)treetable.getTreetableModel().getTreeModel();
        boolean isDropOn = false;
        DataFlavor dataFlavor = new DataFlavor(PackObjects.class, this.dataProvider.getFlavourName());
        if (!support.isDataFlavorSupported(dataFlavor)) {
            return false;
        }
        try {
            int row;
            PackObjects packObjects = (PackObjects)support.getTransferable().getTransferData(dataFlavor);
            if (packObjects == null) {
                return false;
            }
            if (!this.dataProvider.isGlobalPack() && !packObjects.isOwner(treetable)) {
                return false;
            }
            if (packObjects.isOwner(treetable)) {
                packObjects = this.localPack;
            }
            if (support.isDrop()) {
                JTable.DropLocation dl = (JTable.DropLocation)support.getDropLocation();
                row = dl.getRow();
                if (!dl.isInsertRow()) {
                    isDropOn = true;
                }
            } else {
                row = treetable.getSelectedRow();
            }
            if (row < 0) {
                row = treetable.getRowCount();
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)treetable.getValueAt(row, 0);
            if (!support.isDrop() && node != null && this.dataProvider.isTreatPasteAsDropOn(packObjects, node)) {
                isDropOn = true;
            }
            if (isDropOn && node != null && this.dataProvider.isTreatDropOnAsNear(packObjects, node)) {
                isDropOn = false;
            }
            DefaultMutableTreeNode parentNode = node == null ? (DefaultMutableTreeNode)treeModel.getRoot() : (isDropOn ? node : (DefaultMutableTreeNode)node.getParent());
            for (Object item : packObjects) {
                Integer nodeHash = packObjects.getNodeHash(item);
                if (nodeHash == null || !this.findNodeInTree(nodeHash, parentNode)) continue;
                return false;
            }
            return this.dataProvider.canImport(packObjects, parentNode);
        }
        catch (UnsupportedFlavorException ex) {
            ex.printStackTrace();
            System.err.println("Unsupported Flavor");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.err.println("Eroare la operatii IO (Serializabil)");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println("Unusual exception in DnD");
        }
        return false;
    }

    private boolean findNodeInTree(Integer res, DefaultMutableTreeNode node) {
        if (node.isRoot()) {
            return false;
        }
        if (res.intValue() == node.hashCode()) {
            return true;
        }
        return this.findNodeInTree(res, (DefaultMutableTreeNode)node.getParent());
    }

    public boolean importData(TransferHandler.TransferSupport support) {
        Component comp;
        Treetable treetable = this.dataProvider.getTreetable();
        if (!treetable.equals(comp = support.getComponent())) {
            return false;
        }
        DefaultTreeModel treeModel = (DefaultTreeModel)treetable.getTreetableModel().getTreeModel();
        boolean isDropOn = false;
        if (!this.canImport(support)) {
            return false;
        }
        try {
            int action;
            int row;
            DataFlavor dataFlavor = new DataFlavor(PackObjects.class, this.dataProvider.getFlavourName());
            PackObjects packObjects = (PackObjects)support.getTransferable().getTransferData(dataFlavor);
            if (!this.dataProvider.isGlobalPack() && !packObjects.isOwner(treetable)) {
                return false;
            }
            if (packObjects.isOwner(treetable)) {
                packObjects = this.localPack;
            }
            if (support.isDrop()) {
                JTable.DropLocation dl = (JTable.DropLocation)support.getDropLocation();
                row = dl.getRow();
                if (!dl.isInsertRow()) {
                    isDropOn = true;
                }
            } else {
                row = treetable.getSelectedRow();
            }
            if (row < 0) {
                row = treetable.getRowCount();
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)treetable.getValueAt(row, 0);
            if (!support.isDrop() && this.dataProvider.isTreatPasteAsDropOn(packObjects, node)) {
                isDropOn = true;
            }
            if (isDropOn && node != null && this.dataProvider.isTreatDropOnAsNear(packObjects, node)) {
                isDropOn = false;
            }
            DefaultMutableTreeNode parentNode = null;
            parentNode = node == null ? (DefaultMutableTreeNode)treeModel.getRoot() : (isDropOn ? node : (DefaultMutableTreeNode)node.getParent());
            int dropNodeIndex = node != null ? (isDropOn ? parentNode.getChildCount() : parentNode.getIndex(node)) : parentNode.getChildCount();
            DefaultMutableTreeNode dropNode = isDropOn ? null : node;
            boolean isMove = false;
            if (support.isDrop() && (action = support.getDropAction()) == 2) {
                isMove = true;
            }
            treetable.clearSelection();
            boolean importIsDone = this.dataProvider.importData(packObjects, parentNode, dropNode, dropNodeIndex, isMove);
            return importIsDone;
        }
        catch (UnsupportedFlavorException ex) {
            ex.printStackTrace();
            System.err.println("Unsupported Flavor");
        }
        catch (IOException ex) {
            ex.printStackTrace();
            System.err.println("Eroare la operatii IO (Serializabil)");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println("Unusual exception in DnD");
        }
        return false;
    }
}

