/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.treetable.search;

import exenne.components.textfield.fixedwidth.JFixedWidthTextField;
import exenne.components.textfield.validator.ColorizingBorder;
import exenne.components.tree.search.TreeNodeSearcher;
import exenne.components.treetable.Treetable;
import exenne.components.treetable.search.JTreetableSearchPaneIcons;
import exenne.components.treetable.search.TreetableStringSearchCriteria;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultMutableTreeNode;

public class JTreetableSearchPane
extends JPanel
implements ActionListener {
    private Treetable treetable;
    private static final String NAME_TEXTFIELD = "Cauta: ";
    private static final String NAME_ANTERIOR = "Anterior";
    private static final String NAME_URMATOR = "Urmator";
    private static final String ACTION_ANTERIOR = "anterior";
    private static final String ACTION_URMATOR = "next";
    private static final String ACTION_AFISEAZA = "show";
    private static final String ACTION_ASCUNDE = "close";
    private static final Color BAD_COLOR = new Color(255, 0, 0);
    private static final Color GOOD_COLOR = new Color(0, 255, 0);
    private static final int START_OFFSET = 10;
    private JTreetableSearchPaneIcons iconProvider;
    private JLabel labelText;
    private JTextField textfield;
    private Border realBorder;
    private Border goodResultBorder;
    private Border badResultBorder;
    private JButton buttonAnterior;
    private JButton buttonUrmator;
    private JButton buttonClose;
    private FocusListener treetableFocusListener = new FocusAdapter(){

        public void focusGained(FocusEvent e) {
            JTreetableSearchPane.this.fireActionAscunde();
        }
    };
    private DocumentListener listenerTextfield = new DocumentListener(){

        public void insertUpdate(DocumentEvent e) {
            JTreetableSearchPane.this.textfield.setBorder(JTreetableSearchPane.this.realBorder);
        }

        public void removeUpdate(DocumentEvent e) {
            JTreetableSearchPane.this.textfield.setBorder(JTreetableSearchPane.this.realBorder);
        }

        public void changedUpdate(DocumentEvent e) {
            JTreetableSearchPane.this.textfield.setBorder(JTreetableSearchPane.this.realBorder);
        }
    };

    public JTreetableSearchPane(Treetable treetable) {
        this.treetable = treetable;
        this.setLayout(new BoxLayout(this, 0));
        this.add(Box.createHorizontalStrut(10));
        this.labelText = new JLabel(NAME_TEXTFIELD);
        this.add(Box.createHorizontalStrut(5));
        this.add(this.labelText);
        this.textfield = new JFixedWidthTextField(200);
        this.add(Box.createHorizontalStrut(5));
        this.add(this.textfield);
        this.buttonAnterior = new JButton();
        this.buttonAnterior.setText(NAME_ANTERIOR);
        this.buttonAnterior.setActionCommand(ACTION_ANTERIOR);
        this.buttonAnterior.addActionListener(this);
        this.buttonAnterior.setIcon(JTreetableSearchPaneIcons.ANTERIOR.getIcon());
        this.add(this.buttonAnterior);
        this.buttonUrmator = new JButton();
        this.buttonUrmator.setText(NAME_URMATOR);
        this.buttonUrmator.setActionCommand(ACTION_URMATOR);
        this.buttonUrmator.addActionListener(this);
        this.buttonUrmator.setIcon(JTreetableSearchPaneIcons.URMATOR.getIcon());
        this.add(this.buttonUrmator);
        this.add(Box.createHorizontalGlue());
        this.buttonClose = new JButton();
        this.buttonClose.setActionCommand(ACTION_ASCUNDE);
        this.buttonClose.addActionListener(this);
        this.buttonClose.setIcon(JTreetableSearchPaneIcons.CLOSE.getIcon());
        this.add(this.buttonClose);
        this.realBorder = this.textfield.getBorder();
        this.goodResultBorder = new ColorizingBorder(this.realBorder, GOOD_COLOR);
        this.badResultBorder = new ColorizingBorder(this.realBorder, BAD_COLOR);
        this.registerTreetableKeyBindings();
        this.registerLocalKeyBindings();
        treetable.addFocusListener(this.treetableFocusListener);
        this.textfield.getDocument().addDocumentListener(this.listenerTextfield);
        this.setVisible(false);
    }

    private void registerTreetableKeyBindings() {
        ActionMap map = this.treetable.getActionMap();
        AbstractAction actionAfiseaza = new AbstractAction(ACTION_AFISEAZA){

            public void actionPerformed(ActionEvent e) {
                JTreetableSearchPane.this.fireActionAfiseaza();
            }
        };
        map.put(actionAfiseaza.getValue("Name"), actionAfiseaza);
        InputMap imap = this.treetable.getInputMap(2);
        imap.put(KeyStroke.getKeyStroke("ctrl F"), actionAfiseaza.getValue("Name"));
    }

    private void registerLocalKeyBindings() {
        ActionMap map = this.getActionMap();
        AbstractAction actionAscunde = new AbstractAction(ACTION_ASCUNDE){

            public void actionPerformed(ActionEvent e) {
                JTreetableSearchPane.this.fireActionAscunde();
            }
        };
        map.put(actionAscunde.getValue("Name"), actionAscunde);
        AbstractAction actionUrmator = new AbstractAction(ACTION_URMATOR){

            public void actionPerformed(ActionEvent e) {
                JTreetableSearchPane.this.fireActionUrmator();
            }
        };
        map.put(actionUrmator.getValue("Name"), actionUrmator);
        InputMap imap = this.getInputMap(1);
        imap.put(KeyStroke.getKeyStroke("ESCAPE"), actionAscunde.getValue("Name"));
        imap.put(KeyStroke.getKeyStroke("ENTER"), actionUrmator.getValue("Name"));
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (ACTION_ANTERIOR.equals(cmd)) {
            this.fireActionAnterior();
        } else if (ACTION_URMATOR.equals(cmd)) {
            this.fireActionUrmator();
        } else if (ACTION_AFISEAZA.equals(cmd)) {
            this.fireActionAfiseaza();
        } else if (ACTION_ASCUNDE.equals(cmd)) {
            this.fireActionAscunde();
        }
    }

    public void fireActionAnterior() {
        String searchString = this.textfield.getText();
        if (searchString != null && !searchString.isEmpty()) {
            TreeNodeSearcher treeNodeSearcher;
            TreetableStringSearchCriteria treetableCriteria = new TreetableStringSearchCriteria(this.treetable, searchString);
            DefaultMutableTreeNode selectedNode = this.treetable.getSelectedNode();
            if (selectedNode != null) {
                treeNodeSearcher = new TreeNodeSearcher(selectedNode, treetableCriteria);
            } else {
                DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.treetable.getTreetableModel().getTreeModel().getRoot();
                treeNodeSearcher = new TreeNodeSearcher(rootNode, treetableCriteria);
            }
            this.doActionDisplayResult(treeNodeSearcher.getPreviousNode());
        }
    }

    public void fireActionUrmator() {
        String searchString = this.textfield.getText();
        if (searchString != null && !searchString.isEmpty()) {
            TreeNodeSearcher treeNodeSearcher;
            TreetableStringSearchCriteria treetableCriteria = new TreetableStringSearchCriteria(this.treetable, searchString);
            DefaultMutableTreeNode selectedNode = this.treetable.getSelectedNode();
            if (selectedNode != null) {
                treeNodeSearcher = new TreeNodeSearcher(selectedNode, treetableCriteria);
            } else {
                DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)this.treetable.getTreetableModel().getTreeModel().getRoot();
                treeNodeSearcher = new TreeNodeSearcher(rootNode, treetableCriteria);
            }
            this.doActionDisplayResult(treeNodeSearcher.getNextNode());
        }
    }

    private void doActionDisplayResult(DefaultMutableTreeNode resultNode) {
        if (resultNode != null) {
            this.treetable.clearSelection();
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)resultNode.getParent();
            if (parentNode != null) {
                this.treetable.expandNode(parentNode);
            }
            this.treetable.selectAndScrollToNode(resultNode);
            this.textfield.setBorder(this.goodResultBorder);
        } else {
            this.textfield.setBorder(this.badResultBorder);
        }
    }

    public void fireActionAfiseaza() {
        if (!this.isVisible()) {
            this.setVisible(true);
            this.textfield.requestFocusInWindow();
            this.textfield.selectAll();
        }
    }

    public void fireActionAscunde() {
        if (this.isVisible()) {
            this.setVisible(false);
        }
    }
}

