/*
 * Decompiled with CFR 0.152.
 */
package exenne.components.treetable.test;

import exenne.components.celleditors.DefaultBigDecimalCellEditor;
import exenne.components.celleditors.DefaultIntegerCellEditor;
import exenne.components.celleditors.DefaultStringCellEditor;
import exenne.components.headerrenderer.MultilineHeaderRenderer;
import exenne.components.jtable.rowheader.JTableRowHeader;
import exenne.components.jtable.rowheader.RowAnnotation;
import exenne.components.jtable.rowheader.RowHeaderCellData;
import exenne.components.jtable.rowheader.RowHeaderModel;
import exenne.components.jtable.rowheader.RunnableSuggestion;
import exenne.components.jtable.rowheader.annotations.FatalRowAnnotation;
import exenne.components.jtable.rowheader.annotations.WarningRowAnnotation;
import exenne.components.jtable.viewportcontainer.JScrollableBottomSpacingContainer;
import exenne.components.transfer.PackObjects;
import exenne.components.tree.expansion.NodeExpansionValidator;
import exenne.components.tree.expansion.TreeNodesUtils;
import exenne.components.treetable.DefaultTreetableModel;
import exenne.components.treetable.RenderDataProvider;
import exenne.components.treetable.RowModel;
import exenne.components.treetable.Treetable;
import exenne.components.treetable.TreetableListSelectionHandler;
import exenne.components.treetable.TreetableModel;
import exenne.components.treetable.cellrenderers.DefaultTreetableCellRenderer;
import exenne.components.treetable.dnd.TransferDataProvider;
import exenne.components.treetable.dnd.TreetableTransferHandler;
import exenne.components.treetable.search.JTreetableSearchPane;
import exenne.components.treetable.test.ControllerNode;
import exenne.components.treetable.test.DoubleValueCellEditor;
import exenne.components.treetable.test.PackNode;
import exenne.components.treetable.undosupport.InsertNodeToParentStandardUndoableEdit;
import exenne.components.treetable.undosupport.RemoveNodeFromParentStandardUndoableEdit;
import exenne.components.utils.ComponentsUtils;
import exenne.components.utils.RandomDataGenerator;
import exenne.components.utils.WindowUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DropMode;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class TreetableTestClass
extends JPanel
implements ActionListener {
    private Treetable treetable;
    private TreeModel treeMdl;
    private TableModel tableMdl;
    private TableColumnModel columns;
    private NodeRowModel rowModel;
    private TreetableModel mdl;
    JTreetableSearchPane treetableSearchPane;
    TreetableListSelectionHandler selectionHandler;
    MultilineHeaderRenderer multirenderer;
    private static final String ACTION_ADD = "add_node";
    private static final String ACTION_DELETE = "del_node";
    JToolBar toolBar;
    JButton buttonAdd;
    JButton buttonDelete;
    private static NodeExpansionValidator expansionValidation = new NodeExpansionValidator(){

        public boolean validate(Object object) {
            if (object instanceof ControllerNode) {
                ControllerNode element = (ControllerNode)object;
                int tip = element.getType();
                switch (tip) {
                    case 0: 
                    case 1: {
                        return true;
                    }
                    case 2: {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
    };
    TransferDataProvider transferDataProvider = new TransferDataProvider(){

        public Treetable getTreetable() {
            return TreetableTestClass.this.treetable;
        }

        public int getSourceActions() {
            return 3;
        }

        public String getFlavourName() {
            return "PcakControllerNode";
        }

        public PackObjects createPack() {
            PackNode pack = new PackNode();
            DefaultMutableTreeNode n = TreetableTestClass.this.treetable.getSelectedNode();
            if (n == null) {
                return null;
            }
            int[] sels = TreetableTestClass.this.treetable.getSelectedIndices();
            for (int i = 0; i < sels.length; ++i) {
                DefaultMutableTreeNode nd = (DefaultMutableTreeNode)TreetableTestClass.this.treetable.getValueAt(sels[i], 0);
                Object userobj = nd.getUserObject();
                Class<?> tip = userobj.getClass();
                if (tip != ControllerNode.class) continue;
                ControllerNode controllerNode = (ControllerNode)userobj;
                pack.add(controllerNode);
                pack.setNode(controllerNode, nd);
                pack.setNodeHash(controllerNode, new Integer(nd.hashCode()));
            }
            return pack;
        }

        public boolean isInhibitExport() {
            return false;
        }

        public void exportDone(PackObjects packObjects) {
            DefaultTreeModel model = (DefaultTreeModel)TreetableTestClass.this.treeMdl;
            ControllerNode item2 = null;
            DefaultMutableTreeNode node = null;
            Vector<DefaultMutableTreeNode> nodesToDelete = new Vector<DefaultMutableTreeNode>();
            for (ControllerNode item2 : packObjects) {
                node = packObjects.getNode(item2);
                nodesToDelete.add(node);
            }
            RemoveMultipleNodesUndoableEdit multipleNodeDelete = new RemoveMultipleNodesUndoableEdit(nodesToDelete);
            multipleNodeDelete.execute();
            multipleNodeDelete.setIsSignificant(false);
            TreetableTestClass.this.treetable.repaint();
        }

        public boolean isGlobalPack() {
            return true;
        }

        public boolean canImport(PackObjects packObjects, DefaultMutableTreeNode parentNode) {
            Object parentObj = parentNode.getUserObject();
            return parentObj.getClass() == ControllerNode.class;
        }

        public boolean importData(PackObjects packObjects, DefaultMutableTreeNode parentNode, DefaultMutableTreeNode dropNode, int dropNodeIndex, boolean isMove) {
            ImportaMultipleNodesUndoableEdit importAction = new ImportaMultipleNodesUndoableEdit(parentNode, packObjects, dropNodeIndex);
            Vector<DefaultMutableTreeNode> newNodes = importAction.execute();
            TreetableTestClass.this.treetable.repaint();
            return true;
        }

        public boolean isTreatDropOnAsNear(PackObjects packObjects, DefaultMutableTreeNode targetNode) {
            ControllerNode controllerNode = (ControllerNode)targetNode.getUserObject();
            return controllerNode.getType() == 2;
        }

        public boolean isTreatPasteAsDropOn(PackObjects packObjects, DefaultMutableTreeNode targetNode) {
            ControllerNode controllerNode = (ControllerNode)targetNode.getUserObject();
            return controllerNode.getType() == 1;
        }
    };

    public TreetableTestClass() {
        this.setLayout(new BorderLayout());
        this.rowModel = new NodeRowModel();
        this.mdl = DefaultTreetableModel.createOutlineModel(this.rowModel);
        this.treetable = new Treetable(new DefaultTreetableCellRenderer());
        this.treeMdl = this.mdl.getTreeModel();
        this.treetable.setRootVisible(false);
        this.mdl.setNodeColumnName("Cod \n (String)");
        this.treetable.setModel(this.mdl);
        this.tableMdl = this.treetable.getModel();
        this.selectionHandler = new TreetableListSelectionHandler(this.treetable);
        this.treetable.getSelectionModel().addListSelectionListener(this.selectionHandler);
        this.treetable.setRenderDataProvider(new RenderData());
        this.treetable.setSelectionMode(2);
        this.treetable.setDefaultEditor(BigDecimal.class, new DefaultBigDecimalCellEditor());
        this.treetable.setDefaultEditor(Integer.class, new DefaultIntegerCellEditor());
        this.treetable.setDefaultEditor(String.class, new DefaultStringCellEditor());
        this.treetable.getTableHeader().setReorderingAllowed(false);
        this.columns = this.treetable.getColumnModel();
        this.treetable.setAutoResizeMode(2);
        this.treetable.setFillsViewportHeight(true);
        this.treetable.setShowHorizontalLines(true);
        this.treetable.setShowVerticalLines(true);
        this.multirenderer = new MultilineHeaderRenderer();
        this.treetable.setDragEnabled(true);
        this.treetable.setDropMode(DropMode.ON_OR_INSERT_ROWS);
        this.treetable.setTransferHandler(new TreetableTransferHandler(this.transferDataProvider));
        this.toolBar = this.createToolBar();
        this.add((Component)this.toolBar, "North");
        this.makeTree();
        this.initKeyBindings();
        this.initialExpand();
        JScrollableBottomSpacingContainer mainContainerPanel = new JScrollableBottomSpacingContainer(this.treetable);
        JScrollPane scrollPane = new JScrollPane(mainContainerPanel);
        RowHeaderData listTreetableModel = new RowHeaderData(this.tableMdl);
        JTableRowHeader rowHeader = new JTableRowHeader(this.treetable, listTreetableModel);
        JScrollableBottomSpacingContainer rowContainerPanel = new JScrollableBottomSpacingContainer(rowHeader);
        scrollPane.setRowHeaderView(rowContainerPanel);
        this.add((Component)scrollPane, "Center");
        this.treetableSearchPane = new JTreetableSearchPane(this.treetable);
        this.add((Component)this.treetableSearchPane, "South");
    }

    private JToolBar createToolBar() {
        JToolBar localToolBar = new JToolBar("Toolbar");
        this.buttonAdd = new JButton("Add node");
        this.buttonAdd.setActionCommand(ACTION_ADD);
        this.buttonAdd.setToolTipText("Add a node");
        this.buttonAdd.addActionListener(this);
        localToolBar.add(this.buttonAdd);
        this.buttonAdd = new JButton("Del node");
        this.buttonAdd.setActionCommand(ACTION_DELETE);
        this.buttonAdd.setToolTipText("Delete a node");
        this.buttonAdd.addActionListener(this);
        localToolBar.add(this.buttonAdd);
        localToolBar.setFocusable(false);
        localToolBar.setFloatable(false);
        localToolBar.setRollover(false);
        return localToolBar;
    }

    private void makeTree() {
        DefaultTreeModel model = (DefaultTreeModel)this.treeMdl;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        ControllerNode element = new ControllerNode();
        root.setUserObject(element);
        int count = 10;
        for (int i = 0; i < count; ++i) {
            element = new ControllerNode();
            DefaultMutableTreeNode nd = new DefaultMutableTreeNode(element);
            int auxCount = RandomDataGenerator.getRandomInt(3);
            for (int j = 0; j < auxCount; ++j) {
                element = new ControllerNode();
                DefaultMutableTreeNode auxNd = new DefaultMutableTreeNode(element);
                nd.add(auxNd);
            }
            root.add(nd);
        }
        model.reload(root);
        this.treetable.expandNode(root);
    }

    private void initKeyBindings() {
        ActionMap map = this.treetable.getActionMap();
        AbstractAction actionWhenEditing = new AbstractAction("actionWhenEditing"){

            public void actionPerformed(ActionEvent e) {
                if (TreetableTestClass.this.treetable.isEditing()) {
                    Action upAction = ComponentsUtils.getActionForKeystroke(TreetableTestClass.this.treetable, KeyStroke.getKeyStroke("UP"));
                    Action downAction = ComponentsUtils.getActionForKeystroke(TreetableTestClass.this.treetable, KeyStroke.getKeyStroke("DOWN"));
                    System.out.println("actionWhenEditing");
                    if (upAction != null && downAction != null) {
                        ActionEvent upEvent = new ActionEvent(TreetableTestClass.this.treetable, 1, (String)upAction.getValue("Name"));
                        ActionEvent downEvent = new ActionEvent(TreetableTestClass.this.treetable, 1, (String)downAction.getValue("Name"));
                        upAction.actionPerformed(upEvent);
                        downAction.actionPerformed(downEvent);
                    }
                } else {
                    Action upAction = ComponentsUtils.getActionForKeystroke(TreetableTestClass.this.treetable, KeyStroke.getKeyStroke("UP"));
                    Action downAction = ComponentsUtils.getActionForKeystroke(TreetableTestClass.this.treetable, KeyStroke.getKeyStroke("DOWN"));
                    System.out.println("actionWhenNotEditing");
                    if (upAction != null && downAction != null) {
                        ActionEvent upEvent = new ActionEvent(TreetableTestClass.this.treetable, 1, (String)upAction.getValue("Name"));
                        ActionEvent downEvent = new ActionEvent(TreetableTestClass.this.treetable, 1, (String)downAction.getValue("Name"));
                        downAction.actionPerformed(downEvent);
                    }
                }
            }
        };
        map.put(actionWhenEditing.getValue("Name"), actionWhenEditing);
        InputMap focusedImap = this.treetable.getInputMap(0);
        focusedImap.put(KeyStroke.getKeyStroke("ENTER"), actionWhenEditing.getValue("Name"));
        InputMap ancestorImap = this.treetable.getInputMap(1);
        ancestorImap.put(KeyStroke.getKeyStroke("ENTER"), actionWhenEditing.getValue("Name"));
    }

    private void initialExpand() {
        TreeNodesUtils.expandToOptimalCoverage(this.treetable, 30);
    }

    private DefaultMutableTreeNode insertEchipamentToNode_silent(DefaultMutableTreeNode parinte, ControllerNode controllerNode, int position) {
        DefaultMutableTreeNode nd = new DefaultMutableTreeNode(controllerNode, true);
        parinte.insert(nd, position);
        return nd;
    }

    private UndoableEdit removeNodeFromParent_semiloud(DefaultMutableTreeNode n) {
        RemoveNodeFromParentStandardUndoableEdit removeAction = new RemoveNodeFromParentStandardUndoableEdit(this.treetable, n);
        removeAction.execute();
        return removeAction;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (ACTION_ADD.equals(cmd)) {
            this.fireActionAdd();
        } else if (ACTION_DELETE.equals(cmd)) {
            this.fireActionDelete();
        }
    }

    public void fireActionAdd() {
        DefaultTreeModel model = (DefaultTreeModel)this.treeMdl;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        DefaultMutableTreeNode parent = this.treetable.getSelectedNode();
        if (parent == null) {
            parent = root;
        }
        ControllerNode controllerNode = new ControllerNode();
        DefaultMutableTreeNode nd = new DefaultMutableTreeNode(controllerNode);
        InsertNodeToParentStandardUndoableEdit insertEdit = new InsertNodeToParentStandardUndoableEdit(this.treetable, nd, parent, parent.getChildCount());
        insertEdit.execute();
        this.repaint();
    }

    public void fireActionDelete() {
        DefaultTreeModel model = (DefaultTreeModel)this.treeMdl;
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        Vector<DefaultMutableTreeNode> nodesToDelete = new Vector<DefaultMutableTreeNode>();
        int[] selectedIndices = this.treetable.getSelectedIndices();
        if (selectedIndices.length <= 0) {
            return;
        }
        for (int i = selectedIndices.length - 1; i >= 0; --i) {
            int j = selectedIndices[i];
            DefaultMutableTreeNode selectedNode = this.treetable.getNodeAt(j);
            if (selectedNode == null) continue;
            nodesToDelete.add(selectedNode);
        }
        RemoveMultipleNodesUndoableEdit multipleNodeDelete = new RemoveMultipleNodesUndoableEdit(nodesToDelete);
        multipleNodeDelete.execute();
        this.repaint();
    }

    private static void createAndShowGUI() {
        WindowUtilities.initLookAndFeel();
        JFrame frame = new JFrame("TreetableTestClass");
        frame.setDefaultCloseOperation(3);
        TreetableTestClass testClass = new TreetableTestClass();
        frame.add(testClass);
        frame.setSize(500, 500);
        frame.setLocationByPlatform(true);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        Locale.setDefault(new Locale("ro", "RO"));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreetableTestClass.createAndShowGUI();
            }
        });
    }

    private class RowHeaderData
    extends RowHeaderModel {
        public RowHeaderData(TableModel tabelModel) {
            super(tabelModel);
        }

        public RowHeaderCellData getListCellData(Object tableObject) {
            if (tableObject instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)tableObject;
                ControllerNode controllerNode = (ControllerNode)node.getUserObject();
                RowHeaderCellData cellData = new RowHeaderCellData();
                if (node.getLevel() == 1) {
                    cellData.setText(node.getParent().getIndex(node) + "");
                }
                Vector<RowAnnotation> annotations = new Vector<RowAnnotation>();
                if (controllerNode.getType() == 1) {
                    WarningRowAnnotation warningRowAnnotation = new WarningRowAnnotation();
                    warningRowAnnotation.setTooltipText("Tooltip text");
                    Vector<RunnableSuggestion> suggestions = new Vector<RunnableSuggestion>();
                    suggestions.add(new RunnableSuggestion(){

                        public String getName() {
                            return "test suggestion";
                        }

                        public void run() {
                            System.out.println(this.getName());
                        }
                    });
                    suggestions.add(new RunnableSuggestion(){

                        public String getName() {
                            return "another entry";
                        }

                        public void run() {
                            System.out.println(this.getName());
                        }
                    });
                    warningRowAnnotation.setSuggestions(suggestions);
                    annotations.add(warningRowAnnotation);
                    FatalRowAnnotation fatalRowAnnotation = new FatalRowAnnotation();
                    fatalRowAnnotation.setTooltipText("Fatal it is");
                    annotations.add(fatalRowAnnotation);
                }
                if (!annotations.isEmpty()) {
                    cellData.setRowAnnotations(annotations);
                }
                return cellData;
            }
            throw new ClassCastException();
        }
    }

    private class RenderData
    implements RenderDataProvider {
        private MultilineHeaderRenderer headerRenderer = new MultilineHeaderRenderer();

        public String getDisplayName(Object o) {
            String name = "";
            DefaultMutableTreeNode nod = (DefaultMutableTreeNode)o;
            ControllerNode usernod = (ControllerNode)nod.getUserObject();
            name = usernod.getCod();
            return name;
        }

        public int getColumnPrefferedWidth() {
            return 200;
        }

        public TableCellRenderer getColumnHeaderRenderer() {
            return this.headerRenderer;
        }

        public Color getBackground(Object o) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)o;
            ControllerNode userObject = (ControllerNode)node.getUserObject();
            switch (userObject.getType()) {
                case 0: {
                    return new Color(0, 0, 255);
                }
                case 1: {
                    return new Color(255, 200, 200);
                }
                case 2: {
                    return new Color(200, 255, 200);
                }
            }
            return null;
        }

        public Color getForeground(Object o) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)o;
            ControllerNode userObject = (ControllerNode)node.getUserObject();
            switch (userObject.getType()) {
                case 0: {
                    return new Color(255, 255, 255);
                }
            }
            return null;
        }

        public String getTooltipText(Object o) {
            return null;
        }

        public Icon getIcon(Object o, boolean isExpanded) {
            return null;
        }

        public boolean isGrouping(Object o) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)o;
            ControllerNode userObject = (ControllerNode)node.getUserObject();
            return userObject.getType() == 0;
        }

        public int getDecimalScale() {
            return 3;
        }
    }

    private class NodeRowModel
    implements RowModel {
        private int scale = 2;
        private MultilineHeaderRenderer headerRenderer = new MultilineHeaderRenderer();

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return BigDecimal.class;
                }
                case 2: {
                    return BigDecimal.class;
                }
                case 3: {
                    return Double.class;
                }
            }
            assert (false);
            return null;
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Name \n(String)";
                }
                case 1: {
                    return "Value \n(BigDecimal)";
                }
                case 2: {
                    return "Value \n(BigDecimal)";
                }
                case 3: {
                    return "value \n(Double)";
                }
            }
            assert (false);
            return null;
        }

        public int getColumnPrefferedWidth(int column) {
            switch (column) {
                case 0: {
                    return 100;
                }
                case 1: {
                    return 100;
                }
                case 2: {
                    return 100;
                }
                case 3: {
                    return 100;
                }
            }
            assert (false);
            return 0;
        }

        public TableCellRenderer getColumnHeaderRenderer(int column) {
            return this.headerRenderer;
        }

        public TableCellEditor getColumnCellEditor(int column) {
            switch (column) {
                case 1: {
                    return new DoubleValueCellEditor();
                }
            }
            return null;
        }

        public Object getValueFor(Object node, int column) {
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)node;
            if (currentNode == null) {
                return null;
            }
            ControllerNode n = (ControllerNode)currentNode.getUserObject();
            switch (column) {
                case 0: {
                    return n.getName();
                }
                case 1: {
                    return n.getValue();
                }
                case 2: {
                    return n.getValue();
                }
                case 3: {
                    return n.getAnotherValue();
                }
            }
            assert (false);
            return null;
        }

        public String getTooltipTextFor(Object node, int column) {
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)node;
            if (currentNode == null) {
                return null;
            }
            ControllerNode n = (ControllerNode)currentNode.getUserObject();
            if (n.getType() == 1 && (column == 3 || column == 0)) {
                return "ole";
            }
            return null;
        }

        public boolean isCellEditable(Object node, int column) {
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)node;
            if (currentNode == null) {
                return false;
            }
            ControllerNode n = (ControllerNode)currentNode.getUserObject();
            return n.getType() == 1;
        }

        public boolean setValueFor(Object node, int column, Object value) {
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)node;
            if (currentNode == null) {
                return false;
            }
            ControllerNode n = (ControllerNode)currentNode.getUserObject();
            switch (column) {
                case 0: {
                    String auxString = (String)value;
                    n.setName(auxString);
                    return true;
                }
                case 1: {
                    BigDecimal auxBigDecimal = (BigDecimal)value;
                    n.setValue(auxBigDecimal);
                    return true;
                }
                case 2: {
                    BigDecimal auxBigDecimal = (BigDecimal)value;
                    n.setValue(auxBigDecimal);
                    return true;
                }
                case 3: {
                    Double auxDouble = (Double)value;
                    n.setAnotherValue(auxDouble);
                    return true;
                }
            }
            assert (false);
            return false;
        }

        public boolean isCellImportant(Object node, boolean isExpanded, int column) {
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)node;
            if (currentNode == null) {
                return false;
            }
            ControllerNode n = (ControllerNode)currentNode.getUserObject();
            return n.getType() == 0 && column == 1 && isExpanded;
        }

        public String getOverwriteString(Object node, boolean isExpanded, int column) {
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)node;
            if (currentNode == null) {
                return null;
            }
            ControllerNode n = (ControllerNode)currentNode.getUserObject();
            if (n.getType() == 2) {
                if (column == 1) {
                    return "";
                }
                if (column == 2) {
                    return "- \" -";
                }
            } else if (n.getType() == 0 && column == 1 && isExpanded) {
                return "";
            }
            return null;
        }

        public Color getOverwriteBackground(Object node, boolean isExpanded, int column) {
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)node;
            if (currentNode == null) {
                return null;
            }
            ControllerNode n = (ControllerNode)currentNode.getUserObject();
            if (n.getType() == 0) {
                if (column == 0) {
                    return Color.CYAN;
                }
            } else if (n.getType() == 2 && column == 3) {
                return Color.LIGHT_GRAY;
            }
            return null;
        }

        public Color getOverwriteForeground(Object node, boolean isExpanded, int column) {
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)node;
            if (currentNode == null) {
                return null;
            }
            ControllerNode n = (ControllerNode)currentNode.getUserObject();
            if (n.getType() == 0 ? column == 0 : n.getType() == 2 && column == 3) {
                return Color.RED;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RemoveMultipleNodesUndoableEdit
    extends AbstractUndoableEdit {
        Vector<DefaultMutableTreeNode> deletedNodes;
        Vector<UndoableEdit> controllerActions;
        Vector<UndoableEdit> guiActions;
        Hashtable<UndoableEdit, UndoableEdit> obiectNotifications;
        UndoableEdit frahtAction;
        private boolean isSignificant;

        public RemoveMultipleNodesUndoableEdit(Vector<DefaultMutableTreeNode> deletedNodes) {
            this.deletedNodes = deletedNodes;
            this.controllerActions = new Vector();
            this.guiActions = new Vector();
            this.obiectNotifications = new Hashtable();
            this.isSignificant = true;
        }

        public void execute() {
            DefaultTreeModel model = (DefaultTreeModel)TreetableTestClass.this.treeMdl;
            for (DefaultMutableTreeNode deleteNode : this.deletedNodes) {
                UndoableEdit guiremove = TreetableTestClass.this.removeNodeFromParent_semiloud(deleteNode);
            }
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
        }

        public void setIsSignificant(boolean value) {
            this.isSignificant = value;
        }

        @Override
        public boolean isSignificant() {
            return this.isSignificant;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ImportaMultipleNodesUndoableEdit
    extends AbstractUndoableEdit {
        DefaultMutableTreeNode parentNode;
        Vector<ControllerNode> controllerNode;
        int position;
        UndoableEdit controllerAction;
        Vector<DefaultMutableTreeNode> newNodes;
        UndoableEdit removeEdit;

        public ImportaMultipleNodesUndoableEdit(DefaultMutableTreeNode parentNode, Vector<ControllerNode> controllerNodes, int position) {
            this.parentNode = parentNode;
            this.controllerNode = controllerNodes;
            this.position = position;
            this.newNodes = new Vector();
            this.removeEdit = null;
        }

        public Vector<DefaultMutableTreeNode> execute() {
            DefaultTreeModel model = (DefaultTreeModel)TreetableTestClass.this.treeMdl;
            for (ControllerNode nodeItem : this.controllerNode) {
                ControllerNode controllerNodNou = nodeItem.cloneaza();
                DefaultMutableTreeNode newNode = TreetableTestClass.this.insertEchipamentToNode_silent(this.parentNode, controllerNodNou, this.position);
                this.newNodes.add(newNode);
                model.nodesWereInserted(this.parentNode, new int[]{this.position++});
            }
            TreetableTestClass.this.treetable.expandNode(this.parentNode);
            for (DefaultMutableTreeNode nodSelectie : this.newNodes) {
                TreetableTestClass.this.treetable.selectAndScrollToNode(nodSelectie);
            }
            return this.newNodes;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InsertMultipleNodesUndoableEdit
    extends AbstractUndoableEdit {
        DefaultMutableTreeNode parentNode;
        Vector<ControllerNode> controllerNode;
        int position;
        UndoableEdit controllerAction;
        Vector<DefaultMutableTreeNode> newNodes;
        UndoableEdit removeEdit;

        public InsertMultipleNodesUndoableEdit(DefaultMutableTreeNode parentNode, Vector<ControllerNode> controllerNodes, int position) {
            this.parentNode = parentNode;
            this.controllerNode = controllerNodes;
            this.position = position;
            this.newNodes = new Vector();
            this.removeEdit = null;
        }

        public Vector<DefaultMutableTreeNode> execute() {
            DefaultTreeModel model = (DefaultTreeModel)TreetableTestClass.this.treeMdl;
            for (ControllerNode nodeItem : this.controllerNode) {
                DefaultMutableTreeNode newNode = TreetableTestClass.this.insertEchipamentToNode_silent(this.parentNode, nodeItem, this.position);
                this.newNodes.add(newNode);
                model.nodesWereInserted(this.parentNode, new int[]{this.position++});
            }
            TreetableTestClass.this.treetable.expandNode(this.parentNode);
            for (DefaultMutableTreeNode nodSelectie : this.newNodes) {
                TreetableTestClass.this.treetable.selectAndScrollToNode(nodSelectie);
            }
            return this.newNodes;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
        }
    }
}

