/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.builtin;

import java.text.Format;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.text.Document;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.builtin.ButtonMustBeSelectedModel;
import org.netbeans.validation.api.builtin.DisallowCharactersValidator;
import org.netbeans.validation.api.builtin.EmailAddressValidator;
import org.netbeans.validation.api.builtin.EmptyStringIllegalValidator;
import org.netbeans.validation.api.builtin.EncodableInCharsetValidator;
import org.netbeans.validation.api.builtin.FileValidator;
import org.netbeans.validation.api.builtin.FormatValidator;
import org.netbeans.validation.api.builtin.HostNameValidator;
import org.netbeans.validation.api.builtin.IllegalCharactersInFileNameValidator;
import org.netbeans.validation.api.builtin.IpAddressValidator;
import org.netbeans.validation.api.builtin.IsANumberValidator;
import org.netbeans.validation.api.builtin.IsAnIntegerValidator;
import org.netbeans.validation.api.builtin.MaximumLength;
import org.netbeans.validation.api.builtin.MayNotContainSpacesValidator;
import org.netbeans.validation.api.builtin.MayNotStartWithDigit;
import org.netbeans.validation.api.builtin.MinimumLength;
import org.netbeans.validation.api.builtin.NonNegativeNumberValidator;
import org.netbeans.validation.api.builtin.NotJavaIdentifierValidator;
import org.netbeans.validation.api.builtin.NumberRange;
import org.netbeans.validation.api.builtin.OrValidator;
import org.netbeans.validation.api.builtin.PositiveNumberValidator;
import org.netbeans.validation.api.builtin.RegexpValidator;
import org.netbeans.validation.api.builtin.SplitStringValidator;
import org.netbeans.validation.api.builtin.TrimStringValidator;
import org.netbeans.validation.api.builtin.UrlValidator;
import org.netbeans.validation.api.builtin.ValidHexadecimalNumberValidator;
import org.netbeans.validation.api.builtin.ValidHostNameOrIPValidator;
import org.netbeans.validation.api.conversion.Converter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Validators implements Validator<String>
{
    REQUIRE_NON_EMPTY_STRING,
    REQUIRE_VALID_FILENAME,
    REQUIRE_VALID_INTEGER,
    REQUIRE_NON_NEGATIVE_NUMBER,
    REQUIRE_POSITIVE_NUMBER,
    REQUIRE_VALID_NUMBER,
    REQUIRE_JAVA_IDENTIFIER,
    VALID_HEXADECIMAL_NUMBER,
    NO_WHITESPACE,
    FILE_MUST_EXIST,
    FILE_MUST_BE_FILE,
    FILE_MUST_BE_DIRECTORY,
    URL_MUST_BE_VALID,
    IP_ADDRESS,
    HOST_NAME,
    HOST_NAME_OR_IP_ADDRESS,
    MAY_NOT_START_WITH_DIGIT,
    EMAIL_ADDRESS,
    CHARACTER_SET_NAME,
    JAVA_PACKAGE_NAME,
    FILE_MUST_NOT_EXIST;


    public Validator<String> forString(boolean trim) {
        Validator<String> result2;
        switch (this) {
            case REQUIRE_JAVA_IDENTIFIER: {
                result2 = new NotJavaIdentifierValidator();
                break;
            }
            case REQUIRE_NON_EMPTY_STRING: {
                result2 = new EmptyStringIllegalValidator();
                break;
            }
            case REQUIRE_NON_NEGATIVE_NUMBER: {
                result2 = new NonNegativeNumberValidator();
                break;
            }
            case REQUIRE_POSITIVE_NUMBER: {
                result2 = new PositiveNumberValidator();
                break;
            }
            case REQUIRE_VALID_FILENAME: {
                result2 = new IllegalCharactersInFileNameValidator();
                break;
            }
            case REQUIRE_VALID_INTEGER: {
                result2 = new IsAnIntegerValidator();
                break;
            }
            case REQUIRE_VALID_NUMBER: {
                result2 = new IsANumberValidator();
                break;
            }
            case VALID_HEXADECIMAL_NUMBER: {
                result2 = new ValidHexadecimalNumberValidator();
                break;
            }
            case NO_WHITESPACE: {
                result2 = new MayNotContainSpacesValidator();
                break;
            }
            case FILE_MUST_BE_DIRECTORY: {
                result2 = new FileValidator(FileValidator.Type.MUST_BE_DIRECTORY);
                break;
            }
            case FILE_MUST_BE_FILE: {
                result2 = new FileValidator(FileValidator.Type.MUST_BE_FILE);
                break;
            }
            case FILE_MUST_EXIST: {
                result2 = new FileValidator(FileValidator.Type.MUST_EXIST);
                break;
            }
            case FILE_MUST_NOT_EXIST: {
                result2 = new FileValidator(FileValidator.Type.MUST_NOT_EXIST);
                break;
            }
            case URL_MUST_BE_VALID: {
                result2 = new UrlValidator();
                break;
            }
            case IP_ADDRESS: {
                result2 = new IpAddressValidator();
                break;
            }
            case HOST_NAME: {
                result2 = new HostNameValidator(true);
                break;
            }
            case HOST_NAME_OR_IP_ADDRESS: {
                result2 = new ValidHostNameOrIPValidator();
                break;
            }
            case MAY_NOT_START_WITH_DIGIT: {
                result2 = new MayNotStartWithDigit();
                break;
            }
            case EMAIL_ADDRESS: {
                EmailAddressValidator result2 = new EmailAddressValidator();
                return result2;
            }
            case JAVA_PACKAGE_NAME: {
                Validator<String> result2 = Validators.splitString("\\.", Validators.merge(false, REQUIRE_JAVA_IDENTIFIER));
                return result2;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (trim) {
            return new TrimStringValidator(result2);
        }
        return result2;
    }

    public <T> Validator<T> forType(Class<T> type, boolean trim) {
        Converter<String, T> conv = Converter.find(String.class, type);
        if (conv == null) {
            throw new IllegalArgumentException("No converter from " + type.getClass().getName() + " to Strings has been " + "registered with Converter.register()");
        }
        return conv.convert(this.forString(trim));
    }

    public Validator<Document> forDocument(boolean trim) {
        return this.forType(Document.class, trim);
    }

    public Validator<ComboBoxModel> forComboBoxModel(boolean trim) {
        return this.forType(ComboBoxModel.class, trim);
    }

    public static Validator<String> disallowChars(char[] chars, boolean trim) {
        DisallowCharactersValidator v = new DisallowCharactersValidator(chars);
        return trim ? new TrimStringValidator(v) : v;
    }

    public static Validator<Document> forDocument(boolean trim, Validator<String> ... validators) {
        Validator<String> first = Validators.merge(validators);
        Converter<String, Document> c = Converter.find(String.class, Document.class);
        return c.convert(first);
    }

    public static Validator<String> merge(boolean trim, Validator<String> ... validators) {
        return trim ? new TrimStringValidator(Validators.merge(validators)) : Validators.merge(validators);
    }

    public static Validator<ComboBoxModel> forComboBox(boolean trim, Validator<String> ... validators) {
        return Converter.find(String.class, ComboBoxModel.class).convert(Validators.merge(validators));
    }

    public static Validator<ButtonModel[]> oneButtonMustBeSelected(String msg) {
        return new ButtonMustBeSelectedModel(msg);
    }

    public static Validator<String> trimString(Validator<String> ... others) {
        if (others == null) {
            throw new NullPointerException("Null validators passed");
        }
        if (others.length == 1) {
            return new TrimStringValidator(others[0]);
        }
        return new TrimStringValidator(new OrValidator<String>(others));
    }

    public static Validator<String> splitString(String regexp, Validator<String> other) {
        return new SplitStringValidator(regexp, other);
    }

    public static Validator<String> regexp(String regexp, String message, boolean acceptPartialMatches) {
        return new RegexpValidator(regexp, message, acceptPartialMatches);
    }

    public static Validator<String> forFormat(Format fmt) {
        return new FormatValidator(fmt);
    }

    public static Validator<String> encodableInCharset(String charsetName) {
        return new EncodableInCharsetValidator(charsetName);
    }

    public static Validator<String> numberRange(Number min, Number max) {
        return new NumberRange(min, max);
    }

    public static Validator<String> minLength(int length) {
        return new MinimumLength(length);
    }

    public static Validator<String> maxLength(int length) {
        return new MaximumLength(length);
    }

    public static <T> Validator<T> merge(Validator<T> ... validators) {
        if (validators == null) {
            throw new NullPointerException();
        }
        if (validators.length == 1) {
            return validators[0];
        }
        return new OrValidator<T>(validators);
    }

    @Override
    public boolean validate(Problems problems, String compName, String model) {
        return this.forString(false).validate(problems, compName, model);
    }

    public Validator<String> trim() {
        return this.forString(true);
    }
}

