/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.celleditors;

import exenne.components.textfield.validator.JValidatorTextfield;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

/**
 * Editorul pentru o celula de tabel cu BigDecimal
 * @author iulian
 */
public class DefaultStringCellEditor extends AbstractCellEditor
        implements TableCellEditor {
    JValidatorTextfield editingComp;
    protected int clickCountToStart = 1;

    /**
     * Constructorul editorului
     */
    public DefaultStringCellEditor(){
        editingComp = new JValidatorTextfield(BorderFactory.createLineBorder(Color.BLACK));
        editingComp.setHorizontalAlignment(JTextField.LEFT);
        editingComp.setValidator(null); //No validation
    }

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *    Etapa de preluare valoare editata
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * Metoda apelata de tabel care intreaba componenta daca se poate opri editarea
     * @return
     */
    @Override
    public boolean stopCellEditing() {
        if (editingComp.isValidValue()) {
            return super.stopCellEditing();
        } else {
            return false;
        }
    }

    /**
     * Obtin valoarea editata
     * @return
     */
    public Object getCellEditorValue(){
        return editingComp.getText();
    }

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *    Etapa de pornire editare
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * Obtin numarul de clickuri pentru a afisa panoul
     * @return
     */
    public int getClickCountToStart(){
        return clickCountToStart;
    }

    /**
     * Setez numarul de clickuri
     * @param clickCountToStart
     */
    public void setClickCountToStart(int clickCountToStart){
        this.clickCountToStart = clickCountToStart;
    }

    /**
     * Preiau evenimentul de mouse si detectez daca este cazul sa pornesc editarea
     * @param e
     * @return
     */
    @Override
    public boolean isCellEditable(EventObject e){
        return !(e instanceof MouseEvent)
                || ((MouseEvent)e).getClickCount()>=clickCountToStart;
    }

    /*---------------------------[ TableCellEditor ]------------------------*/

    /**
     * Metoda apelata de tabel pentru a obtine editorul
     * @param table
     * @param value
     * @param isSelected
     * @param row
     * @param column
     * @return
     */
    public Component getTableCellEditorComponent(JTable table, Object value
            , boolean isSelected, int row, int column){
        editingComp.setText((String)value);
        editingComp.setCaretPosition(0);
        editingComp.selectAll();
        return editingComp;
    }
}