/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package exenne.components.comboactionbox;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

/**
 * Construiesc un ComboBox ce contine numai pachete de actiuni
 * @author iulian
 */
public class JComboActionBox extends JComboBox 
        implements ItemListener {
    private final ActionComboItem defaultAction = new ActionComboItem("<selectati>"); 
    
    /**
     * Contructor secundar
     * @param items 
     */
    public JComboActionBox(Vector<ActionComboItem> items) {
        this(null, items);
    }
    
    /**
     * Se construieste pe un vector de actiuni.
     * @param items 
     */
    public JComboActionBox(String defaultName, Vector<ActionComboItem> items) {
        super();
    
        //Pun actiunea nula la inceput
        defaultAction.setName(defaultName);
        items.insertElementAt(defaultAction, 0);
        this.setModel(new DefaultComboBoxModel(items));
        
        //Setez ca si listener pentru actiuni
        this.addItemListener(this);
    }

    /**
     * Metoda apelata la schimbarea selectiei
     * @param e 
     */
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == ItemEvent.SELECTED ) {
            ActionComboItem selectedItem = (ActionComboItem) e.getItem();
            
            if (selectedItem != defaultAction) {
                //Resetez selectia in combo
                this.setPopupVisible(false);
                this.setSelectedIndex(0);                
                
                //Execut actiunea
                selectedItem.executeAction();
            }
        }
    }
}
