/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package exenne.components.treetable.search;

import exenne.components.textfield.fixedwidth.JFixedWidthTextField;
import exenne.components.textfield.validator.ColorizingBorder;
import exenne.components.tree.search.TreeNodeSearcher;
import exenne.components.treetable.Treetable;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultMutableTreeNode;

/**
 * Clasa ce afiseaza un panou de cautare
 * Atentie !
 *  Clasa inregistreaza urmatoarele keybindinguri:
 *   ESC - panou cautare 		(local) WHEN_ANCESTOR_OF_FOCUSED_COMPONENT
 *   Ctrl+F - treetable 			(global) WHEN_IN_FOCUSED_WINDOW
 *  Keybindingul de la treetable este periculos daca se afiseaza mai multe treetabel-uri 
 *  ce ofera aceasta functionalitate. In aces caz se va afisa decat panoul pentru primul
 * 
 * @author iulian
 */
public class JTreetableSearchPane extends JPanel 
    implements ActionListener {
    //Variabile de clasa
    private Treetable treetable;
    
    //Constante nume
    private static final String NAME_TEXTFIELD = "Cauta: ";
    private static final String NAME_ANTERIOR = "Anterior";
    private static final String NAME_URMATOR = "Urmator";
    
    //Constante actiuni
    private static final String ACTION_ANTERIOR = "anterior";
    private static final String ACTION_URMATOR = "next";
    private static final String ACTION_AFISEAZA = "show";
    private static final String ACTION_ASCUNDE = "close";
    
    //Constanta pentru culoare
    private static final Color BAD_COLOR = new Color(255, 0, 0);
    private static final Color GOOD_COLOR = new Color(0, 255, 0);
    
    //Constante dimensiuni
    private static final int START_OFFSET = 10;
    
    //Providerul de icoane
    private JTreetableSearchPaneIcons iconProvider;
    
    //Structura panoului
    private JLabel labelText;
    private JTextField textfield;
        private Border realBorder;
        private Border goodResultBorder;
        private Border badResultBorder;
    private JButton buttonAnterior;
    private JButton buttonUrmator;
    private JButton buttonClose;
    
    /**
     * COnstruiesc panoul de cautare
     */
    public JTreetableSearchPane(Treetable treetable) {
        super();
        
        //Pastrez variabilele
        this.treetable = treetable;
        
        //Fac panoul
        this.setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
        this.add(Box.createHorizontalStrut(START_OFFSET));
            labelText = new JLabel(NAME_TEXTFIELD);
        this.add(Box.createHorizontalStrut(5));
        this.add(labelText);
            textfield = new JFixedWidthTextField(200);
        this.add(Box.createHorizontalStrut(5));
        this.add(textfield);
            buttonAnterior = new JButton();
            buttonAnterior.setText(NAME_ANTERIOR);
            buttonAnterior.setActionCommand(ACTION_ANTERIOR);
            buttonAnterior.addActionListener(this);
            buttonAnterior.setIcon(JTreetableSearchPaneIcons.ANTERIOR.getIcon());
        this.add(buttonAnterior);
            buttonUrmator = new JButton();
            buttonUrmator.setText(NAME_URMATOR);
            buttonUrmator.setActionCommand(ACTION_URMATOR);
            buttonUrmator.addActionListener(this);
            buttonUrmator.setIcon(JTreetableSearchPaneIcons.URMATOR.getIcon());
        this.add(buttonUrmator);
        this.add(Box.createHorizontalGlue());
            buttonClose = new JButton();
            buttonClose.setActionCommand(ACTION_ASCUNDE);
            buttonClose.addActionListener(this);
            buttonClose.setIcon(JTreetableSearchPaneIcons.CLOSE.getIcon());
        this.add(buttonClose);
        
        //Pregatesc borderele
        this.realBorder = textfield.getBorder();
        this.goodResultBorder = new ColorizingBorder(realBorder,GOOD_COLOR);
        this.badResultBorder = new ColorizingBorder(realBorder,BAD_COLOR);
        
        //Pregatesc panoul de cautare
        registerTreetableKeyBindings();
        registerLocalKeyBindings();
        treetable.addFocusListener(treetableFocusListener);
        textfield.getDocument().addDocumentListener(listenerTextfield);
        
        //Panoul porneste ascuns
        this.setVisible(false);
    }

    /**
     * Inregistrez key bindingurile in treetable
     */
    private void registerTreetableKeyBindings() {

        //   Maparea actiunilor pe nume
        //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        ActionMap map = treetable.getActionMap();
        //Wrapper peste actiunea de adaugare
        Action actionAfiseaza = new AbstractAction(ACTION_AFISEAZA) {
            public void actionPerformed(ActionEvent e) {
                fireActionAfiseaza();
            }
        };
        map.put(actionAfiseaza.getValue(Action.NAME),
                actionAfiseaza);


        //   Maparea numelor pe taste
        //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        InputMap imap = treetable.getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW);
        imap.put(KeyStroke.getKeyStroke("ctrl F"),
            actionAfiseaza.getValue(Action.NAME));
    }
    
    /**
     * Inregistrez key bindingurile in treetable
     */
    private void registerLocalKeyBindings() {

        //   Maparea actiunilor pe nume
        //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        ActionMap map = this.getActionMap();
        //Wrapper peste actiunea de adaugare
        Action actionAscunde = new AbstractAction(ACTION_ASCUNDE) {
            public void actionPerformed(ActionEvent e) {
                fireActionAscunde();
            }
        };
        map.put(actionAscunde.getValue(Action.NAME),
                actionAscunde);
        //Wrapper peste actiunea de adaugare
        Action actionUrmator = new AbstractAction(ACTION_URMATOR) {
            public void actionPerformed(ActionEvent e) {
                fireActionUrmator();
            }
        };
        map.put(actionUrmator.getValue(Action.NAME),
                actionUrmator);


        //   Maparea numelor pe taste
        //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        InputMap imap = this.getInputMap(JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT);
        imap.put(KeyStroke.getKeyStroke("ESCAPE"),
            actionAscunde.getValue(Action.NAME));
        imap.put(KeyStroke.getKeyStroke("ENTER"),
            actionUrmator.getValue(Action.NAME));
    }
    
    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *      Actiuniile de cautare
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
    
    /**
     * Tratez actiuniile
     * @param e 
     */
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (ACTION_ANTERIOR.equals(cmd)) {
            fireActionAnterior();
        } else
        if (ACTION_URMATOR.equals(cmd)) {
            fireActionUrmator();
        } else
        if (ACTION_AFISEAZA.equals(cmd)) {
            fireActionAfiseaza();
        } else
        if (ACTION_ASCUNDE.equals(cmd)) {
            fireActionAscunde();
        }
    }
    
    /**
     * Lansez actiune de afisare rezultat anterior
     */
    public void fireActionAnterior() {
        String searchString = textfield.getText();
        if (searchString != null && !searchString.isEmpty()) {
            TreetableStringSearchCriteria treetableCriteria = 
                    new TreetableStringSearchCriteria(treetable, searchString);
            DefaultMutableTreeNode selectedNode = treetable.getSelectedNode();
            TreeNodeSearcher treeNodeSearcher;
            if (selectedNode != null) 
                treeNodeSearcher = new TreeNodeSearcher(selectedNode, treetableCriteria);
            else {
                DefaultMutableTreeNode rootNode = 
                    (DefaultMutableTreeNode) treetable.getTreetableModel().getTreeModel().getRoot();
                treeNodeSearcher = new TreeNodeSearcher(rootNode, treetableCriteria);
            }

            //Afisez rezultatul
            doActionDisplayResult(treeNodeSearcher.getPreviousNode());
        }
    }
    
    /**
     * Lansez actiunea de afisare rezultat urmator
     */
    public void fireActionUrmator() {
        String searchString = textfield.getText();
        if (searchString != null && !searchString.isEmpty()) {
            TreetableStringSearchCriteria treetableCriteria = 
                    new TreetableStringSearchCriteria(treetable, searchString);
            DefaultMutableTreeNode selectedNode = treetable.getSelectedNode();
            TreeNodeSearcher treeNodeSearcher;
            if (selectedNode != null) 
                treeNodeSearcher = new TreeNodeSearcher(selectedNode, treetableCriteria);
            else {
                DefaultMutableTreeNode rootNode = 
                    (DefaultMutableTreeNode) treetable.getTreetableModel().getTreeModel().getRoot();
                treeNodeSearcher = new TreeNodeSearcher(rootNode, treetableCriteria);
            }

            //Afisez rezultatul
            doActionDisplayResult(treeNodeSearcher.getNextNode());
        }
    }
    
    /**
     * Fac actiunea de afisare rezultat
     */
    private void doActionDisplayResult(DefaultMutableTreeNode resultNode) {
        if (resultNode != null) {
            //Il afisez in arbore
            treetable.clearSelection();
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode) resultNode.getParent();
            if (parentNode != null)
                treetable.expandNode(parentNode);
            treetable.selectAndScrollToNode(resultNode);
            textfield.setBorder(goodResultBorder);
        } else {
            textfield.setBorder(badResultBorder);
        }
    }
    
    /**
     * Lansez actiunea de afisare panou cautare
     */
    public void fireActionAfiseaza() {
        if (!this.isVisible()) {
            this.setVisible(true);
            textfield.requestFocusInWindow();
            textfield.selectAll();
        }
    }
    
    /**
     * Lansez actiunea de ascundere panou cautare
     */
    public void fireActionAscunde() {
        if (this.isVisible()) {
            this.setVisible(false);
        }
    }
    
    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *      Clase interne
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/
    /**
     * Ascultator de focus in treetable
     */
    private FocusListener treetableFocusListener = new FocusAdapter() {
        @Override
        public void focusGained(FocusEvent e) {
            fireActionAscunde();
        }
    };
    
    /**
     * Ascultator textfield pentru resetare culoare la editare
     */
    private DocumentListener listenerTextfield = new DocumentListener() {
        public void insertUpdate(DocumentEvent e) {
            textfield.setBorder(realBorder);
        }
        public void removeUpdate(DocumentEvent e) {
            textfield.setBorder(realBorder);
        }
        public void changedUpdate(DocumentEvent e) {
            textfield.setBorder(realBorder);
        }
    };
}
