/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.undosystem;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

/**
 * Un undoable edit care se asigura ca componenta este vizibila
 * @author iulian
 */
public class EnsureComponentVisibleEdit extends AbstractUndoableEdit {
    private ICanBeVisible component;
    private UndoableEdit undoableEdit;

    /**
     * Construiesc un edit
     * @param component
     * @param undoableEdit
     */
    public EnsureComponentVisibleEdit(ICanBeVisible component,
            UndoableEdit undoableEdit) {
        super();

        this.component = component;
        this.undoableEdit = undoableEdit;
    }

    /**
     * Obtin componenta de care este legata actiunea
     * @return
     */
    public ICanBeVisible getComponent() {
        return component;
    }


    @Override
    public void undo() throws CannotUndoException {
        super.undo();

        //Ensure component is visible
        component.makeSureIsVisible();

        //Make the undo
        undoableEdit.undo();
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();

        //Ensure component is visible
        component.makeSureIsVisible();

        //Make the redo
        undoableEdit.redo();
    }
}
