/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.checktree;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

/**
 *
 * @author iulian
 */
public class CheckTreeManager extends MouseAdapter implements TreeSelectionListener{
    private CheckTreeSelectionModel selectionModel;
    private JTree tree = new JTree();
    int hotspot = new JCheckBox().getPreferredSize().width;

    //Configurez ascultatorii
    Vector<CheckTreeSelectionListener> listeners;
    
    //Constant for action
    private static final String TOGGLE_PATH = "toggle";

    /**
     * Main constructor
     * @param tree
     */
    public CheckTreeManager(JTree tree){
        this.tree = tree;
        selectionModel = new CheckTreeSelectionModel(tree.getModel());
        tree.setCellRenderer(new CheckTreeCellRenderer(tree.getCellRenderer(), selectionModel));
        tree.addMouseListener(this);
        selectionModel.addTreeSelectionListener(this);

        //Initializez ascultatorii
        listeners = new Vector<CheckTreeSelectionListener> ();
        
        //Keybinding for space activation
        initKeyBindings();
    }

    /**
     * Listener for click action
     * @param me
     */
    @Override
    public void mouseClicked(MouseEvent me){
        TreePath path = tree.getPathForLocation(me.getX(), me.getY());
        if(path==null)
            return;
        if(me.getX()>tree.getPathBounds(path).x+hotspot)
            return;

        //We switch the clicked path
        togglePathState(path);
    }

    /**
     * Test wheater to check or uncheck a path
     * @param path
     */
    public void togglePathState(TreePath path) {
        boolean selected = selectionModel.isPathSelected(path, true);
        selectionModel.removeTreeSelectionListener(this);

        try{
            if(selected)
                selectionModel.removeSelectionPath(path);
            else
                selectionModel.addSelectionPath(path);
        } finally{
            selectionModel.addTreeSelectionListener(this);
            tree.treeDidChange();
            
            //Notific ascultatorii
            notifyListeners(path);
        }
    }

    /**
     * Fac key bindingurile pentru tabel
     */
    public void initKeyBindings() {

        //   Mapping of actions vs names
        //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        ActionMap map = tree.getActionMap();

        //Wrapper peste actiunea de proprietati
        Action actionEnter = new AbstractAction(TOGGLE_PATH) {
            public void actionPerformed(ActionEvent e) {
                TreePath treePath = tree.getSelectionPath();
                if (treePath != null)
                    togglePathState(treePath);
            }
        };
        map.put(actionEnter.getValue(Action.NAME),
                actionEnter);


        //   Mapping of names vs keys
        //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        InputMap imap = tree.getInputMap();
        imap.put(KeyStroke.getKeyStroke("SPACE"),
            actionEnter.getValue(Action.NAME));
    }

    /**
     * Get the selection model
     * @return
     */
    public CheckTreeSelectionModel getSelectionModel(){
        return selectionModel;
    }

    /**
     * Hook to refresh the tree
     * @param e
     */
    public void valueChanged(TreeSelectionEvent e){
        tree.treeDidChange();
    }
    
     /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *      Administrare ascultatori
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/ 
    
    /**
     * Adaug un ascultator la checktree
     * @param listener 
     */
    public void addCheckedTreeSelectionListener(CheckTreeSelectionListener listener) {
        listeners.add(listener);
    }
    
    /**
     * Sterg un ascultator de la checktree
     * @param listener 
     */
    public void removeCheckedTreeSelectionListener(CheckTreeSelectionListener listener) {
        listeners.remove(listener);
    }
    
    /**
     * Notifica ascultatorii de prezenta unui eveniment
     */
    private void notifyListeners(TreePath path) {
        for (CheckTreeSelectionListener listener : listeners) {
            listener.pathStateChanged(path);
        }
    }
}