/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.coloredtable.filter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.RowFilter;

/**
 *
 * @author iulian
 */
public class RegexRowFilter extends GeneralRowFilter {
        private Matcher matcher;
        private Pattern regex;

        private RegexRowFilter(String regexString, int[] columns) {
            super(columns);

            regex = Pattern.compile(regexString.toLowerCase());
            if (regex == null) {
                throw new IllegalArgumentException("Pattern must be non-null");
            }
            matcher = regex.matcher("");
        }

        protected boolean include(
                Entry<? extends Object,? extends Object> value, int index) {
            matcher.reset(value.getStringValue(index).toLowerCase());
            return matcher.find();
        }

        /**
         * Metoda statica de obtinere a filtrului
         * @param <M>
         * @param <I>
         * @param regex
         * @param indices
         * @return
         */
        public static <M,I> RowFilter<M,I> getRegexFilter(String regex,
                                                               int... indices) {
                return (RowFilter<M,I>)new RegexRowFilter(regex,
                                                       indices);
        }
    }