/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.livelabel;

import java.awt.Graphics;
import javax.swing.JLabel;

/**
 * Un JLabel care afiseaza live valoarea unui obiect
 * @author iulian
 */
public class JLiveLabel extends JLabel {
    private LivelabelModel livelabelModel;

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    //   Constructorii principali
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    
    public JLiveLabel(LivelabelModel livelabelModel) {
        super();
        this.livelabelModel = livelabelModel;
        this.setText(livelabelModel.getRenderString());
    }

    public JLiveLabel(Object object) {
        this(new DefaultLivelabelModel(object));
    }

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    //   Setteri si getteri
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

    public LivelabelModel getLivelabelModel() {
        return livelabelModel;
    }

    public void setLivelabelModel(LivelabelModel livelabelModel) {
        this.livelabelModel = livelabelModel;
        this.setText(livelabelModel.getRenderString());
    }

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    //   Afisarea componentei folosind modelul
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    @Override
    protected void paintComponent(Graphics g) {
        this.setText(livelabelModel.getRenderString());
        super.paintComponent(g);
    }
}
