/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package exenne.components.miscellaneous.infolines;

import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

/**
 *
 * @author iulian
 */
public class JInformationLine extends JPanel {
    //Constante pentru tipul de informatie
    public static final int TYPE_INFO = 0;
    public static final int TYPE_SEVERE = 1;
    
    //Componentele
    Border panelBorder;
    JLabel labelInformatii;
    

    /**
     * Contructor secundar
     * @param message 
     */
    public JInformationLine(String message) {
        this(message, TYPE_INFO);
    }
    
    /**
     * Construiesc o linie de mesaj
     * @param message 
     */
    public JInformationLine(String message, int messageType) {
        super();
        
        //Fac setarile de layout
        this.setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
        Border emptyBorder = BorderFactory.createEmptyBorder(5, 10, 5, 10);
        Border shadeBorder = BorderFactory.createEtchedBorder();
        this.panelBorder = BorderFactory.createCompoundBorder(shadeBorder, emptyBorder);
        this.setOpaque(true);
        
        //Adaug componentele
        labelInformatii = new JLabel(message);
        
        //Fac layout-ul
        this.setShowBorder(true);
        this.setMessageType(messageType);
        this.add(labelInformatii);
        this.add(Box.createHorizontalGlue());
    }

    /**
     * Schimba mesajul din label
     * @param message 
     */
    public void setMessage(String message) {
        labelInformatii.setText(message);
    }
    
    /**
     * Seteaza tipul mesajului
     */
    public void setMessageType(int messageType) {
        this.setBackground(JInformationLine.getBackgroundColor(messageType));
        this.setOpaque(true);
        labelInformatii.setIcon(JInformationLine.getIcon(messageType));
        labelInformatii.setBackground(JInformationLine.getBackgroundColor(messageType));
        labelInformatii.setForeground(JInformationLine.getForegroundColor(messageType));
    }
    
    /**
     * Seteaza daca sa se afiseze sau nu border
     * @param shouldShowBorder 
     */
    public void setShowBorder(boolean shouldShowBorder) {
        if (shouldShowBorder) {
            this.setBorder(panelBorder);
        } else {
            this.setBorder(null);
        }
    }
    
    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *       Metode statice pentru switch intre tipuri
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * Obtin culoarea de fundal pentru mesaj
     * @param type
     * @return 
     */
    private static Color getBackgroundColor(int type) {
        switch (type) {
            case TYPE_INFO:
                return Color.WHITE;
            case TYPE_SEVERE:
                return Color.WHITE;
            default:
                return null;
        }
    }
    
    /**
     * Obtin culoarea de fundal pentru mesaj
     * @param type
     * @return 
     */
    private static Color getForegroundColor(int type) {
        switch (type) {
            case TYPE_INFO:
                return Color.BLUE;
            case TYPE_SEVERE:
                return Color.RED;
            default:
                return null;
        }
    }
    
    /**
     * Obtin iconul potrivit
     * @param type
     * @return 
     */
    private static Icon getIcon(int type) {
        switch (type) {
            case TYPE_INFO:
                return JInformationIcons.INFO.getIcon();
            case TYPE_SEVERE:
                return JInformationIcons.SEVERE.getIcon();
            default:
                return JInformationIcons.INFO.getIcon();
        }
    } 
}
