/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.panelholder;

import exenne.components.tabbedpane.INeedCleanup;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;

/**
 *
 * @author iulian
 */
public class JPanelHolder extends JPanel
    implements INeedCleanup {
    private JPanel displayPanel;

    /**
     * Construiesc un container cu continut schimbabil
     */
    public JPanelHolder() {
        super();

        //Setez layoutul
        setLayout(new BorderLayout());

        //Initializez display panelul la o valoare
        displayPanel = new JPanel();
        this.add(displayPanel,BorderLayout.CENTER);
    }

    /**
     * Setez continutul panoului
     * @param panel
     */
    public void setDisplayPanel(JPanel panel) {
        if (!displayPanel.equals(panel)) {
            //Sterg display panelul actual
            this.remove(displayPanel);
            if (displayPanel instanceof INeedCleanup) {
                ((INeedCleanup) displayPanel).cleanup();
            }

            //setez noul display panel
            displayPanel = panel;
            this.add(panel,BorderLayout.CENTER);

            //Revalidez layooutul
            this.revalidate();
        }
    }

    /**
     * Obtin panoul afisat momentan
     * @return
     */
    public JPanel getDisplayPanel() {
        return displayPanel;
    }

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *      Clean-up
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * Functie ce este apelata la inchiderea ferestrei
     * Ea trebuie sa deinregistreze ascultatorii
     */
    public void cleanup() {
        //Iterez prin taburi si le fac cleanup
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; i++) {
            Component component = components[i];
            if (component instanceof INeedCleanup)
                ((INeedCleanup) component).cleanup();
        }
    }
}
