/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.propertiespanel;

import exenne.components.jdatepicker.util.JDatePickerUtil;
import exenne.components.propertiespanel.editors.JCheckBoxPropertiesEditor;
import exenne.components.propertiespanel.editors.JColorChooserPropertiesEditor;
import exenne.components.propertiespanel.editors.JComboBoxPropertiesEditor;
import exenne.components.propertiespanel.editors.JDatePickerPropertiesEditor;
import exenne.components.propertiespanel.editors.JFileChooserPropertiesEditor;
import exenne.components.propertiespanel.editors.JImageChooserPropertiesEditor;
import exenne.components.propertiespanel.editors.JTextAreaPropertiesEditor;
import exenne.components.propertiespanel.editors.JTextFieldPropertiesEditor;
import exenne.components.propertiespanel.headers.JLabelPropertiesHeader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.WindowConstants;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;
import org.netbeans.validation.api.Problem;
import org.netbeans.validation.api.Severity;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.builtin.DateDayRange;
import org.netbeans.validation.api.builtin.Validators;

/**
 *
 * @author iulian
 */
public class TestWindow extends JFrame {
    private final static String LOOKANDFEEL = "System"; //Look and feel-ul folosit
    private final static String THEME = "Ocean";     // Tema folosita pentru Metal

    private JPropertiesPanel propertiesPanel;
    private JButton commitButton;

    /**
     * Constructorul principal
     */
    public TestWindow() {
        initLookAndFeel();
        this.setSize (600 , 500);
        this.setLocation(150,0);
        this.setDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);
        this.setLayout(new BorderLayout());

        //Setez panoul
        propertiesPanel = new JPropertiesPanel(panelModel);
        propertiesPanel.addValidationProblemListener(new IValidationProblemListener() {
            public void validationProblemChanged(Problem problem) {
                boolean enable = problem == null ? true : problem.severity() != Severity.FATAL;

                commitButton.setEnabled(enable);
                TestWindow.this.setDefaultCloseOperation(!enable ?
                  WindowConstants.DO_NOTHING_ON_CLOSE :
                  WindowConstants.EXIT_ON_CLOSE);

            }
        });

        this.add(propertiesPanel,BorderLayout.CENTER);

        commitButton = new JButton("Commit");
        commitButton.addActionListener(new ActionListener() {

            public void actionPerformed(ActionEvent e) {
                boolean hasChanged = propertiesPanel.commitChanges();
                System.out.println("hasChanged = "+hasChanged);
            }
        });

        this.add(commitButton,BorderLayout.SOUTH);
        this.pack();
    }

    /**
     *  <p style="margin-top: 0">
     *         Initializeaza Look and Feel. Default este cel al sistemului.
     *      </p>
     * @param titlu Titlul ferestrei
     * @author iulian
     */
    public static void initLookAndFeel() {
        String lookAndFeel = null;
        if (LOOKANDFEEL != null) {
            if (LOOKANDFEEL.equals("Metal")) {
                lookAndFeel = UIManager.getCrossPlatformLookAndFeelClassName();
              //  an alternative way to set the Metal L&F is to replace the
              // previous line with:
              // lookAndFeel = "javax.swing.plaf.metal.MetalLookAndFeel";
            }
            else if (LOOKANDFEEL.equals("System")) {
                lookAndFeel = UIManager.getSystemLookAndFeelClassName();
            }
            else if (LOOKANDFEEL.equals("Motif")) {
                lookAndFeel = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
            }
            else if (LOOKANDFEEL.equals("GTK")) {
                lookAndFeel = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
            }
            else {
                System.err.println("Unexpected value of LOOKANDFEEL specified: "
                                   + LOOKANDFEEL);
                lookAndFeel = UIManager.getCrossPlatformLookAndFeelClassName();
            }
            try {
                UIManager.setLookAndFeel(lookAndFeel);
                // If L&F = "Metal", set the theme
               if (LOOKANDFEEL.equals("Metal")) {
                  if (THEME.equals("DefaultMetal"))
                     MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
                  else if (THEME.equals("Ocean"))
                     MetalLookAndFeel.setCurrentTheme(new OceanTheme());
                  UIManager.setLookAndFeel(new MetalLookAndFeel());
                }
            }

            catch (ClassNotFoundException e) {
                System.err.println("Couldn't find class for specified look and feel:"
                                   + lookAndFeel);
                System.err.println("Did you include the L&F library in the class path?");
                System.err.println("Using the default look and feel.");
            }

            catch (UnsupportedLookAndFeelException e) {
                System.err.println("Can't use the specified look and feel ("
                                   + lookAndFeel
                                   + ") on this platform.");
                System.err.println("Using the default look and feel.");
            }

            catch (Exception e) {
                System.err.println("Couldn't get specified look and feel ("
                                   + lookAndFeel
                                   + "), for some reason.");
                System.err.println("Using the default look and feel.");
                e.printStackTrace();
            }
        }
    }

    //Modelul de test
    private AbstractPropertiesPanelModel panelModel = new AbstractPropertiesPanelModel() {
        //Constante
        private static final int FIELD_ROWS = 3;
        private static final int FIELD_WIDTH = 150;
        private static final int LABEL_WIDTH = 150;

        //Fac maparea numelor pe randuri
        public static final int ROW_0 = 0;
        public static final int ROW_1 = 1;
        public static final int ROW_2 = 2;
        public static final int ROW_3 = 3;
        public static final int ROW_4 = 4;
        public static final int ROW_5 = 5;
        public static final int ROW_6 = 6;
        public static final int ROW_7 = 7;
        public static final int ROW_8 = 8;
        public static final int ROW_9 = 9;
        public static final int ROW_10 = 10;

        //Variabile de clasa
        private String textfieldString = "test value";
        private Integer textfieldInteger = 21;
        private BigDecimal textfieldBigDecimal = new BigDecimal("232.123");
        private String textareaString = "ole ole \n newline \n ole";
        private Date datePickerDate = new Date(2011-1900, 0, 1);
        private String comboString = "cal";
            private String[] comboValues = {"pisica","cal","magar","urs"};
        private Boolean checkboxBoolean = false;
        private Boolean checkboxBooleanSecond = false;
        private Color colorChooserColor = Color.blue;
        private File fileChooserFile = new File("/home/iulian");
        private BufferedImage bufferedImage = 
                new BufferedImage(100, 100, BufferedImage.TYPE_4BYTE_ABGR);

        @Override
        public int getRowCount() {
            return 11;
        }

        @Override
        public int getLabelWidth() {
            return LABEL_WIDTH;
        }

        @Override
        public Class getClassAt(int row) {
            switch (row) {
                case ROW_0:     return String.class;
                case ROW_1:     return Integer.class;
                case ROW_2:     return BigDecimal.class;
                case ROW_3:     return String.class;
                case ROW_4:     return Date.class;
                case ROW_5:     return String.class;
                case ROW_6:     return Boolean.class;
                case ROW_7:     return Boolean.class;
                case ROW_8:     return Color.class;
                case ROW_9:     return File.class;
                case ROW_10:    return BufferedImage.class;
                default:    assert false; return null;
            }
        }

        @Override
        public String getDescriptionAt(int row) {
            switch (row) {
                case ROW_0:     return "textfield String";
                case ROW_1:     return "textfield Integer";
                case ROW_2:     return "textfield BigDecimal";
                case ROW_3:     return "textarea String";
                case ROW_4:     return "datePicker Date";
                case ROW_5:     return "combo String";
                case ROW_6:     return null;
                case ROW_7:     return null;
                case ROW_8:     return "colorChooser Color";
                case ROW_9:     return "fileChooser File";
                case ROW_10:    return "imageChoose BufferedImage";
                default:    assert false; return null;
            }
        }

        @Override
        public IPropertiesEditor createEditorComponentAt(int row) {
            switch (row) {
                case ROW_0:     return new JTextFieldPropertiesEditor(FIELD_WIDTH);
                case ROW_1:     return new JTextFieldPropertiesEditor(FIELD_WIDTH,"%");
                case ROW_2:     return new JTextFieldPropertiesEditor(FIELD_WIDTH);
                case ROW_3:     return new JTextAreaPropertiesEditor(FIELD_ROWS, FIELD_WIDTH);
                case ROW_4:     return new JDatePickerPropertiesEditor();
                case ROW_5:     return new JComboBoxPropertiesEditor(new JComboBox(comboValues));
                case ROW_6:     return new JCheckBoxPropertiesEditor("Test1");
                case ROW_7:     return new JCheckBoxPropertiesEditor("Test2");
                case ROW_8:     return new JColorChooserPropertiesEditor();
                case ROW_9:     return new JFileChooserPropertiesEditor(TestWindow.this, FIELD_WIDTH);
                case ROW_10:    return new JImageChooserPropertiesEditor(TestWindow.this, FIELD_WIDTH,165,60);
                default:    assert false; return null;
            }
        }

        /**
         * Obtin tipul componentei ce va fi
         * @return
         */
        public IPropertiesHeader createHeaderComponentAt(int row) {
            switch (row) {
                case ROW_0:     return new JLabelPropertiesHeader("header1");
                case ROW_1:     return null;
                case ROW_2:     return null;
                case ROW_3:     return null;
                case ROW_4:     return null;
                case ROW_5:     return new JLabelPropertiesHeader("header2");
                case ROW_6:     return null;
                case ROW_7:     return null;
                case ROW_8:     return null;
                case ROW_9:     return null;
                case ROW_10:    return null;
                default:    assert false; return null;
            }
        }

        @Override
        public void fireActionRowChanged(int row) {
            switch (row) {
                case ROW_1:
                    IPropertiesEditor myEditor = getEditorComponentAt(ROW_1);
                    IPropertiesEditor hisEditor = getEditorComponentAt(ROW_2);

                    Integer integer = (Integer) myEditor.getValue(Integer.class);
                    BigDecimal bigDecimal = new BigDecimal(integer.intValue());
                    bigDecimal = bigDecimal.add(BigDecimal.ONE);

                    if (bigDecimal.compareTo(BigDecimal.TEN) > 0 )
                        hisEditor.setValue(BigDecimal.class, bigDecimal);
                    break;
                default:
                    break;
            }
        }

        @Override
        public boolean isRowOnNewline(int row) {
            switch (row) {
                case ROW_7:     return false;
                default:    return true;
            }
        }

        @Override
        public Validator getValidatorAt(int row) {
            switch (row) {
                case ROW_0:
                    return
                            Validators.forDocument(false,
                            Validators.REQUIRE_NON_EMPTY_STRING);
                case ROW_1:
                    return Validators.forDocument(false,
                            Validators.REQUIRE_NON_EMPTY_STRING,
                            Validators.REQUIRE_VALID_INTEGER,
                            Validators.REQUIRE_NON_NEGATIVE_NUMBER);
                case ROW_2:
                    return Validators.forDocument(false,
                            Validators.REQUIRE_NON_EMPTY_STRING,
                            Validators.REQUIRE_VALID_NUMBER,
                            Validators.REQUIRE_NON_NEGATIVE_NUMBER);
                case ROW_3:
                    return Validators.forDocument(false,
                            Validators.REQUIRE_NON_EMPTY_STRING);
                case ROW_4:
                    return Validators.forDocument(false,
                            Validators.REQUIRE_NON_EMPTY_STRING,
                            new DateDayRange(JDatePickerUtil.getMediumDateFormat(),
                                datePickerDate, null, false));
                case ROW_9:
                    return Validators.forDocument(false,
                            Validators.REQUIRE_NON_EMPTY_STRING,
                            Validators.FILE_MUST_EXIST);
                default:    return null;
            }
        }

        @Override
        public int getRowHeightAt(int row) {
            switch (row) {
                case ROW_3:  return 100;
                default: return AbstractPropertiesPanelModel.AUTO_HEIGHT;
            }
        }        
        
        @Override
        public Object getValueAt(int row) {
            switch (row) {
                case ROW_0:     return textfieldString;
                case ROW_1:     return textfieldInteger;
                case ROW_2:     return textfieldBigDecimal;
                case ROW_3:     return textareaString;
                case ROW_4:     return datePickerDate;
                case ROW_5:     return comboString;
                case ROW_6:     return checkboxBoolean;
                case ROW_7:     return checkboxBooleanSecond;
                case ROW_8:     return colorChooserColor;
                case ROW_9:     return fileChooserFile;
                case ROW_10:    return bufferedImage;
                default:    assert false; return null;
            }
        }

        @Override
        public boolean setValueAt(int row, Object newValue) {
            String auxString;
            Integer auxInteger;
            BigDecimal auxBigDecimal;
            Date auxDate;
            Boolean auxBoolean;
            Color auxColor;
            File auxFile;
            BufferedImage auxBufferedImage;

            System.out.println(row+"->"+newValue);

            if (getValueAt(row).equals(newValue))
                return false;

            switch (row) {
                case ROW_0:
                    auxString = (String) newValue;
                    textfieldString = auxString;
                    return true;
                case ROW_1:
                    auxInteger = (Integer) newValue;
                    textfieldInteger = auxInteger;
                    return true;
                case ROW_2:
                    auxBigDecimal = (BigDecimal) newValue;
                    textfieldBigDecimal = auxBigDecimal;
                    return true;
                case ROW_3:
                    auxString = (String) newValue;
                    textareaString = auxString;
                    return true;
                case ROW_4:
                    auxDate = (Date) newValue;
                    datePickerDate = auxDate;
                    return true;
                case ROW_5:
                    auxString = (String) newValue;
                    comboString = auxString;
                    return true;
                case ROW_6:
                    auxBoolean = (Boolean) newValue;
                    checkboxBoolean = auxBoolean;
                    return true;
                case ROW_7:
                    auxBoolean = (Boolean) newValue;
                    checkboxBooleanSecond = auxBoolean;
                    return true;
                case ROW_8:
                    auxColor = (Color) newValue;
                    colorChooserColor = auxColor;
                    return true;
                case ROW_9:
                    auxFile = (File) newValue;
                    fileChooserFile = auxFile;
                    return true;
                case ROW_10:
                    auxBufferedImage = (BufferedImage) newValue;
                    bufferedImage = auxBufferedImage;
                    return true;
                default:
                   return false;
            }
        }
    };

    /**
    * Mainul clasei de test
    * @param args
    */
    public static void main(String[] args) {
        Locale.setDefault(new Locale("ro", "RO"));

        TestWindow testWindow = new TestWindow();
        testWindow.setVisible(true);

    }
}
