/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package exenne.components.treetable.search;

import exenne.components.tree.search.INodeSearchCriteria;
import exenne.components.treetable.RenderDataProvider;
import exenne.components.treetable.RowModel;
import exenne.components.treetable.Treetable;
import java.util.regex.Pattern;
import javax.swing.tree.DefaultMutableTreeNode;

/**
 * Criteriul pentru cautare string in treetable
 * @author iulian
 */
public class TreetableStringSearchCriteria implements INodeSearchCriteria{
    private Treetable treetable;
    private String searchString;
    private Pattern pattern;
    
    //Modelele
    private RenderDataProvider renderDataProvider;
    private RowModel rowModel;
    private int[] stringColumnVector;
    
    
    /**
     * Construiesc un criteriu pentru cautare in treetable
     * @param treetable
     * @param searchString 
     */
    public TreetableStringSearchCriteria(Treetable treetable, String searchString) {
        this.treetable = treetable;
        this.searchString = searchString;
        this.pattern = Pattern.compile(Pattern.quote(searchString),Pattern.CASE_INSENSITIVE);
        
        //Obtin modelele
        renderDataProvider = treetable.getRenderDataProvider();
        rowModel = treetable.getTreetableModel().getRowModel();
        
        //Numar coloanele cu tipul string
        int stringColumns = 0;
        for (int i = 0; i < rowModel.getColumnCount(); i++) {
            if (String.class.equals(rowModel.getColumnClass(i)))
                stringColumns++;
        }
    
        //Obtin coloanele
        int index = 0;
        stringColumnVector = new int[stringColumns];
        for (int i = 0; i < rowModel.getColumnCount(); i++) {
            if (String.class.equals(rowModel.getColumnClass(i))) {
                stringColumnVector[index] = i;
            }
        }
    }
    
    
    /**
     * Testeaza un anumit nod din arbore
     * @param node
     * @return 
     */
    public boolean validateNode(DefaultMutableTreeNode node) {
        boolean searchResult = false;
        
        //Testez cu coloana principala
        String displayName = renderDataProvider.getDisplayName(node);
        if (displayName != null)
            searchResult = pattern.matcher(displayName).find()
                    || searchResult; 
        
        //Testez cu coloanele secundare
        for (int i : stringColumnVector) {
            String value = (String) rowModel.getValueFor(node, i);
            if (value != null)
                searchResult = pattern.matcher(value).find()
                        || searchResult;
        }
        
        
        //Intorc rezultatul
        return searchResult;
    }
    
}
