/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package exenne.components.verticaltoolbar;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JToolBar;

/**
 * Contruiesc un toolbar Vertical
 * @author iulian
 */
public class JVerticalToolbar extends JPanel {
    private static final int VERTICAL_SPACING = 4;
    private static final int END_GLUE_SIZE = 3000;
    
    public JVerticalToolbar() {
        super();

        //Setez layout-ul
        this.setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
    }
    
    /**
     * Adaugare separator
     */
    public void addSeparator() {
        this.addComponent(new JToolBar.Separator());
    }
    
    /**
     * Adauga o componenta la toolbar
     * @param comp 
     */
    public void addComponent(Component comp) {
        this.add(wrapComponent(comp));
        this.add(Box.createVerticalStrut(VERTICAL_SPACING));
    }
    
    /**
     * Adaug glue la sfarsit pentru umplerea oricarui spatiu
     */
    public void addEndGlue() {
        this.add(Box.createVerticalStrut(END_GLUE_SIZE));
    }
    
    /**
     * Imbrac un obiect intr-un JPanel pentru a umple tot spatiul alocat
     * @param component
     * @return 
     */
    private JPanel wrapComponent(Component component) {
        //Imbrac pentru a se ajusta marimea
        JPanel wrappingPane = new JPanel();
            wrappingPane.setLayout(new BorderLayout());
            wrappingPane.add(component,BorderLayout.CENTER);
            
        //Intorc wrapperul
        return wrappingPane;
    }
}
