/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.jdatepicker;

import exenne.components.jdatepicker.impl.JDatePickerImpl;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Calendar;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;

/**
 *
 * @author iulian
 */
public class TestPicker extends JFrame {
    private final static String LOOKANDFEEL = "System"; //Look and feel-ul folosit
    private final static String THEME = "Ocean";     // Tema folosita pentru Metal
    private String lookandfeel;
    private JDatePickerImpl datePicker;

    public TestPicker(String title) {
        super(title);

        //Initializez fereastra
        initLookAndFeel();
        this.setSize (1200 , 500);
        this.setLocation(100,0);
        this.setUndecorated(false);
        this.addWindowListener(windowListener);

        //Testez date-pickerul

        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(300,300));
        datePicker = (JDatePickerImpl)JDateComponentFactory.createJDatePicker();
        panel.add(datePicker);

        JButton test = new JButton("test");
        test.setActionCommand("test");
        test.addActionListener(buttonListener);
        panel.add(test);
        this.getContentPane().add(panel);

        this.setVisible(true);
    }

     /**
     *  <p style="margin-top: 0">
     *         Initializeaza Look and Feel. Default este cel al sistemului.
     *      </p>
     * @param titlu Titlul ferestrei
     * @author iulian
     */
    private void initLookAndFeel() {
        String lookAndFeel = null;
        if (LOOKANDFEEL != null) {
            if (LOOKANDFEEL.equals("Metal")) {
                lookAndFeel = UIManager.getCrossPlatformLookAndFeelClassName();
              //  an alternative way to set the Metal L&F is to replace the
              // previous line with:
              // lookAndFeel = "javax.swing.plaf.metal.MetalLookAndFeel";
            }
            else if (LOOKANDFEEL.equals("System")) {
                lookAndFeel = UIManager.getSystemLookAndFeelClassName();
            }
            else if (LOOKANDFEEL.equals("Motif")) {
                lookAndFeel = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
            }
            else if (LOOKANDFEEL.equals("GTK")) {
                lookAndFeel = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
            }
            else {
                System.err.println("Unexpected value of LOOKANDFEEL specified: "
                                   + LOOKANDFEEL);
                lookAndFeel = UIManager.getCrossPlatformLookAndFeelClassName();
            }
            try {
                UIManager.setLookAndFeel(lookAndFeel);
                // If L&F = "Metal", set the theme
               if (LOOKANDFEEL.equals("Metal")) {
                  if (THEME.equals("DefaultMetal"))
                     MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
                  else if (THEME.equals("Ocean"))
                     MetalLookAndFeel.setCurrentTheme(new OceanTheme());
                  UIManager.setLookAndFeel(new MetalLookAndFeel());
                }
            }

            catch (ClassNotFoundException e) {
                System.err.println("Couldn't find class for specified look and feel:"
                                   + lookAndFeel);
                System.err.println("Did you include the L&F library in the class path?");
                System.err.println("Using the default look and feel.");
            }

            catch (UnsupportedLookAndFeelException e) {
                System.err.println("Can't use the specified look and feel ("
                                   + lookAndFeel
                                   + ") on this platform.");
                System.err.println("Using the default look and feel.");
            }

            catch (Exception e) {
                System.err.println("Couldn't get specified look and feel ("
                                   + lookAndFeel
                                   + "), for some reason.");
                System.err.println("Using the default look and feel.");
                e.printStackTrace();
            }
        }
    }

    /**
     *  <p style="margin-top: 0">
     *  Clasa ce reprezinta un ascultator pe Fereastra principala
     *  </p>
     * @author iulian
     */
    WindowListener windowListener = new WindowListener() {

      public void windowClosing(WindowEvent e) {
        System.exit(0);
      }

      public void windowOpened(WindowEvent e) {
      }

      public void windowClosed(WindowEvent e) {
      }

      public void windowIconified(WindowEvent e) {
      }

      public void windowDeiconified(WindowEvent e) {
      }

      public void windowActivated(WindowEvent e) {
      }

      public void windowDeactivated(WindowEvent e) {
      }

    };

    ActionListener buttonListener = new ActionListener() {

        public void actionPerformed(ActionEvent e) {
            Calendar calendar = (Calendar) datePicker.getJFormattedTextField().getValue();
            System.out.println(calendar.getTime());
        }
    };

    public static void main(String[] args) {
        TestPicker testPicker = new TestPicker("test jdatepicker");
        
    }
}
