/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package exenne.components.jtable.rowheader;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.SwingConstants;

/**
 *
 * @author iulian
 */
public class JRowHeaderCellRenderer extends DefaultListCellRenderer {
    public JRowHeaderCellRenderer() {
        this.setBorder(null);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, 
        int index, boolean isSelected, boolean cellHasFocus) {
        
        //Call in parinte pentru initializare
        super.getListCellRendererComponent(list, value, index, 
                isSelected, cellHasFocus);
        
        //Aliniez la dreapta
        this.setHorizontalAlignment(SwingConstants.RIGHT);
        
        //Fac desenarea custom
        if (value instanceof RowHeaderCellData) {
            RowHeaderCellData listCellData = (RowHeaderCellData) value;
            
            //Setez datele
            Icon icon = listCellData.getIcon();
            if (icon != null) {
                this.setText(null);
                this.setIcon(icon);
                this.setToolTipText(listCellData.getTooltipText());  
            } else {
                this.setText(listCellData.getText());
                this.setIcon(null);
                this.setToolTipText(listCellData.getTooltipText()); 
            }
            
            //Setez fundalul
            this.setBackground(listCellData.getBackgroundColor());
            this.setForeground(listCellData.getForegroundColor());
        } else {
            this.setText(value.toString());
        }
        
        //Intorc aceasta instanta
        return this;
    }
    
}
