/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.swingworkers.progressworker;

import java.util.concurrent.Callable;

/**
 *
 * @author iulian
 */
public abstract class AbstractProgressCallable<V> 
        implements Callable<V>, ProgressInfoManager {
    //Constante pentru valori granite
    private static final int INF_LIMIT = 0;
    private static final int SUP_LIMIT = 100;

    //Variabile pentru progres
    private int inferiorLimit = INF_LIMIT;
    private int superiorLimit = SUP_LIMIT;

    //Pastrez un ascultator
    private ProgressInfoManager progressInfoManager;

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *    Local setters
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * Setez progres info managerul
     * @param progressInfoManager
     */
    public void setProgressInfoManager(ProgressInfoManager progressInfoManager) {
        this.progressInfoManager = progressInfoManager;
    }

    /**
     * Setez limita inferioara
     * @param inferiorLimit
     */
    public void setInferiorLimit(int inferiorLimit) {
        this.inferiorLimit = inferiorLimit;
    }

    /**
     * Setez limita superioara
     * @param superiorLimit
     */
    public void setSuperiorLimit(int superiorLimit) {
        this.superiorLimit = superiorLimit;
    }


    /**
     * Setez limitele in care intra progresul ce se va inregistra ulterior
     * @param inferiorLimit
     * @param superiorLimit
     */
    public void setProgressRange(int inferiorLimit, int superiorLimit) {
        setInferiorLimit(inferiorLimit);
        setSuperiorLimit(superiorLimit);
    }

    /**~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     *    ProgressInfoManager implementation
     *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * Setez textul de informare
     * @param info
     */
    public void setProgressInfo(String info) {
        if (progressInfoManager != null)
            progressInfoManager.setProgressInfo(info);
    }

    /**
     * Setez valoarea progresului
     * @param value
     */
    public void setProgressValue(int value) {
        if (progressInfoManager != null) {
            int var1 = inferiorLimit*(SUP_LIMIT-value);
            int var2 = superiorLimit*value;
            int newValue = (var1+var2)/SUP_LIMIT;
            progressInfoManager.setProgressValue(newValue);
        }
    }

    /**
     * Adaug un mesaj de eroare la stringul de mesaje
     * @param error 
     */
    public void addErrorMessage(String error) {
        if (progressInfoManager != null) 
            progressInfoManager.addErrorMessage(error);
    }
    

}
