/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.treetable;

import exenne.components.utils.ComponentsUtils;
import java.awt.*;
import javax.swing.*;

/**
 * Icon pentru TreeTable
 *
 * @author iulian
 */
public class JHandleIcons {
    //Il fac singleton
    private static JHandleIcons instance = null;
    
    public static final String ICON_PLUS = "/exenne/components/treetable/images/plus16.gif";
    public static final String ICON_MINUS = "/exenne/components/treetable/images/minus16.gif";
    public static final String ICON_TOOLTIP = "/exenne/components/treetable/images/tooltip16.gif";

    public static final int PLUS = 0;
    public static final int MINUS = 1;
    public static final int TOOLTIP = 2;

    private Image iconPlus;
    private Image iconMinus;
    private Image iconTooltip;

    private ImageIcon imageIconPlus;
    private ImageIcon imageIconMinus;
    private ImageIcon imageIconTooltip;

    private Icon noIcon;

    private JHandleIcons() {
        noIcon = null;
        loadIcons();
    }

    /**
     * Metoda de obtinere clasa
     * @return 
     */
    public static JHandleIcons getInstance() {
        if (instance == null)
            instance = new JHandleIcons();
        
        return instance;
    }
    
    /**
     * Incarc imaginile pentru icoane
     */
    public void loadIcons() {
        //Iconul pentru Plus
        iconPlus = ComponentsUtils.createImage(ICON_PLUS);
        imageIconPlus = new ImageIcon(iconPlus);

        //Iconul pentru Minus
        iconMinus = ComponentsUtils.createImage(ICON_MINUS);
        imageIconMinus = new ImageIcon(iconMinus);

        //Iconul pentru Tooltip
        iconTooltip = ComponentsUtils.createImage(ICON_TOOLTIP);
        imageIconTooltip = new ImageIcon(iconTooltip);
    }

    /**
     * Obtine iconul pentru handle
     * @param type      Tipul elementului
     * @return Iconul pentru element sau noIcon
     */
    public Icon getIcon(int type) {
        switch (type) {
            case PLUS:
                return imageIconPlus;
            case MINUS:
                return imageIconMinus;
            case TOOLTIP:
                return imageIconTooltip;
            default:
                return noIcon;
        }
    }
}