/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package exenne.components.treetable.warningrowbar;

import exenne.components.jtable.rowheader.JTableRowHeader;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

/**
 *
 * @author iulian
 */
public class JWarningRowBar extends JTableRowHeader {
    //variabile de clasa
    private WarningRowBarModel warningBarModel;

    /**
     * Constructor secundar
     * @param jtable
     * @param listModel 
     */
    public JWarningRowBar(JTable jtable, WarningRowBarModel listModel) {
        super(jtable, listModel);
        init(warningBarModel);
    }    
    
    /**
     * Constructorul principal
     * @param jtable
     * @param warningBarModel
     * @param cols 
     */
    public JWarningRowBar(JTable jtable, WarningRowBarModel warningBarModel, int cols) {
        super(jtable, warningBarModel, cols);
        init(warningBarModel);
    }

    /**
     * Functia de initializare varibile
     * @param warningBarModel 
     */
    private void init(WarningRowBarModel warningBarModel) {
        this.warningBarModel = warningBarModel;
        
        //Inregistrez mouse listenerul
        this.addMouseListener(mouseListener);
    }
    
    
    /**
     * Mouse listenerul ce proceseaza evenimentele pe celule
     */
    private MouseListener mouseListener = new MouseAdapter() {
        @Override
        public void mouseClicked(MouseEvent e) {
            super.mouseClicked(e);
            
            JList sourceList = (JList) e.getSource();
            int row = sourceList.locationToIndex(e.getPoint());
            if (row == -1)
                return;
            
            Rectangle cellBounds = sourceList.getCellBounds(row, row);
            int popupX = (int) (cellBounds.getX()+cellBounds.getWidth()+5);
            int popupY = (int) (cellBounds.getY()+cellBounds.getHeight());
            
            //Obtin Datele de la randul respectiv
            WarningBarCellData cellData = (WarningBarCellData) sourceList.getModel().getElementAt(row);
            Vector <RunnableSuggestion> suggestions = cellData.getSuggestions();
            if (suggestions != null && !suggestions.isEmpty())  {
                JSuggestionsPopup suggestionsPopup = new JSuggestionsPopup(suggestions);
                suggestionsPopup.show(sourceList, popupX, popupY);
            }
        }
        
        /**
         * Operatiunea efectuata la intrarea mouse-ului in componenta
         */
        @Override
        public void mouseEntered(MouseEvent e) {
            super.mouseEntered(e);
            
            final JList sourceList = (JList) e.getSource();
            
            int row = sourceList.locationToIndex(e.getPoint());
            if (row == -1)
                return;
            
            Rectangle cellBounds = sourceList.getCellBounds(row, row);
            final int middleX = (int) (cellBounds.getX()+cellBounds.getWidth()/2);
            final int middleY = (int) (cellBounds.getY()+cellBounds.getHeight()/2);
            
            //Simulez un eveniment de mouse
            SwingUtilities.invokeLater(new Runnable() {
                public void run() {
                    MouseEvent moveEvent = new MouseEvent(sourceList, 0, 0, 0,
                                    middleX, middleY, // X-Y of the mouse for the tool tip
                                    0, false);
                    int initialDelay = ToolTipManager.sharedInstance().getInitialDelay();
                    ToolTipManager.sharedInstance().setInitialDelay(0);
                    ToolTipManager.sharedInstance().mouseMoved(moveEvent);
                    ToolTipManager.sharedInstance().setInitialDelay(initialDelay);
                }
            });
        }
    };
    
}
