/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.tree.expansion;

import exenne.components.treetable.Treetable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

/**
 *
 * @author iulian
 */
public class TreeNodesUtils {
      /*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
      *    Tree utils
      *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~*/

    /**
     * Cauta un obiect in arbore. Arborele se parcurge in maniera
     * @param object
     * @return
     */
    public static DefaultMutableTreeNode findObjectInTree(DefaultMutableTreeNode node,
            Object object) {
        Enumeration enumeration = node.breadthFirstEnumeration();

        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode nodeItem = (DefaultMutableTreeNode)
                    enumeration.nextElement();
            Object userObject = nodeItem.getUserObject();

            if (object != null && object.equals(userObject))
                return nodeItem;
        }

        //Daca nu s-a gasit nimic intorc null
        return null;
    }

    /**
     * Cauta un obiect in arbore. Arborele se parcurge in maniera
     * @param object
     * @return
     */
    public static Vector<DefaultMutableTreeNode> findObjectsInTree(DefaultMutableTreeNode node,
            Vector<Object> objects) {
        Vector<DefaultMutableTreeNode> foundNodes = new Vector<DefaultMutableTreeNode>();

        Enumeration enumeration = node.depthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            DefaultMutableTreeNode nodeItem = (DefaultMutableTreeNode)
                    enumeration.nextElement();
            Object userObject = nodeItem.getUserObject();

            if (objects.contains(userObject))
                foundNodes.add(nodeItem);
        }

        //Daca nu s-a gasit nimic intorc null
        return foundNodes;
    }

    /*
     * Face expand complet la un arbore
     * expand = true - expandAll else collapseAll
     */
    public static void expandAll(JTree tree, boolean expand) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
    // Traverse tree from root
        expandAll(tree, new TreePath(root), expand);
    }

    /*
     * Face expand complet la un arbore
     * expand = true - expandAll else collapseAll
     */
    public static void expandAll(Treetable treetable,DefaultMutableTreeNode root, boolean expand) {
    // Traverse tree from root
        expandAll(treetable, new TreePath(root), expand);
    }

     /*
     * Face expand complet la un arbore pornind de la root
     * expand = true - expandAll else collapseAll
     */
    private static void expandAll(JTree tree, TreePath parent, boolean expand) {
        // Traverse children
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            for (Enumeration e=node.children(); e.hasMoreElements(); ) {
                TreeNode n = (TreeNode)e.nextElement();
                if (!n.isLeaf())
                {
                    TreePath path = parent.pathByAddingChild(n);
                    expandAll(tree, path, expand);
                }
            }
        }
        // Expansion or collapse must be done bottom-up
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

     /*
     * Face expand complet la un treetable pornind de la root
     * expand = true - expandAll else collapseAll
     */
    private static void expandAll(Treetable treetable, TreePath parent, boolean expand) {
        // Traverse children
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            for (Enumeration e=node.children(); e.hasMoreElements(); ) {
                TreeNode n = (TreeNode)e.nextElement();
                if (!n.isLeaf())
                {
                    TreePath path = parent.pathByAddingChild(n);
                    expandAll(treetable, path, expand);
                }
            }
        }
        // Expansion or collapse must be done bottom-up
        if (expand) {
            treetable.expandPath(parent);
        } else {
            boolean isRoot = ((DefaultMutableTreeNode)parent.getLastPathComponent()).isRoot();
            if (!isRoot) treetable.collapsePath(parent);
        }
    }

     /*
     * Face expand complet la un treetable ce contine ElementeDevizGeneral
     * expand = true - expandAll else collapseAll
     */
    public static void expandAllButClasses(Treetable treetable, TreePath parent,
            boolean expand, Class... forbidenClasses) {
        // Traverse children
        List forbidenClassesList = Arrays.asList(forbidenClasses);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)
                parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            for (Enumeration e=node.children(); e.hasMoreElements(); ) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode) e.nextElement();
                Object object =  n.getUserObject();
                Class objectClass = object.getClass();
                if ((!n.isLeaf()) && (!forbidenClassesList.contains(objectClass)))
                {
                    System.out.println(objectClass);
                    TreePath path = parent.pathByAddingChild(n);
                    expandAllButClasses(treetable, path, expand, forbidenClasses);
                }
            }
        }
        // Expansion or collapse must be done bottom-up
        if (expand) {
            treetable.expandPath(parent);
        } else {
            treetable.collapsePath(parent);
        }
    }

     /*
     * Face expand complet la un treetable ce contine ElementeDevizGeneral
     * expand = true - expandAll else collapseAll
     */
    public static void expandAllWithValidation(Treetable treetable, TreePath parent,
            boolean expand, NodeExpansionValidator validator) {
        // Traverse children
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)
                parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            for (Enumeration e=node.children(); e.hasMoreElements(); ) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode) e.nextElement();
                Object object =  n.getUserObject();
                if ((!n.isLeaf()) && (validator.validate(object)))
                {
                    TreePath path = parent.pathByAddingChild(n);
                    expandAllWithValidation(treetable, path, expand, validator);
                }
            }
        }
        // Expansion or collapse must be done bottom-up
        if (expand) {
            treetable.expandPath(parent);
        } else {
            treetable.collapsePath(parent);
        }
    }
}
