/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.treetable.dnd;

import exenne.components.transfer.PackObjects;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

/**
 *
 * @author iulian
 */

public class TransferPackObjects implements Transferable {
    //Numarul tipurile suportate
    private Vector<DataFlavor> flavors;

    //Incarcatura de transfer
    private Hashtable<String,PackObjects> hashtable;


    /**
     * Constructorul default
     */
    public TransferPackObjects() {
        initialize();
    }

    /**
     * Creez un transport avand un packet de Ingrediente
     * @param pack
     */
    public TransferPackObjects(PackObjects pack) {
        initialize();

        //Inregistrez pachetul
        addPackObjects(pack);
    }

    /**
     * Initializeaza Structurile de date
     */
    private void initialize() {
        flavors = new Vector<DataFlavor>();
        hashtable = new Hashtable<String, PackObjects>();
    }

    /**
     * Adaug un pachet la transfer
     * @param pack
     */
    public void addPackObjects(PackObjects pack) {
        DataFlavor dataFlavor = new DataFlavor(PackObjects.class, pack.getFlavorName());
        flavors.add(dataFlavor);

        //Setez incarcatura
        String hashKey = dataFlavor.getHumanPresentableName();
        hashtable.put(hashKey, pack);
    }

    /**
     * Intorc toate tipurile suportate
     */
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] array = new DataFlavor[flavors.size()];
        return flavors.toArray(array);
    }

    /**
     * Testez daca un tip este suportat
     * @param flavor Verific daca un tip este suportat
     * @return true daca se poate folosi
     */
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavors.contains(flavor);
    }

    /**
     * Optin incarcatura transformata in formatul specificat
     * @param flavor Tipul in care se va formata rezultatul
     * @return Obiectul care reprezinta transferul
     */
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (isDataFlavorSupported(flavor)) {
            String hashKey = flavor.getHumanPresentableName();
            return hashtable.get(hashKey);
        } return null;
    }

}
