/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.headerrenderer;

import exenne.components.utils.ComponentsUtils;
import java.awt.*;
import javax.swing.*;

/**
 * Icon pentru TreeTable
 *
 * @author iulian
 */
public class JHeaderSorterIcons  {
    public static final String ICON_ASC = "/exenne/components/headerrenderer/images/up16.gif";
    public static final String ICON_DESC = "/exenne/components/headerrenderer/images/down16.gif";

    public static final int ASC = 0;
    public static final int DESC = 1;

    private Image iconUp;
    private Image iconDown;

    private ImageIcon imageIconUp;
    private ImageIcon imageIconDown;

    private Icon noIcon;

    public JHeaderSorterIcons() {
        noIcon = null;
        loadIcons();
    }

    /**
     * Incarc imaginile pentru icoane
     */
    public void loadIcons() {
        //Iconul pentru Stare
        iconUp = ComponentsUtils.createImage(ICON_ASC);
        imageIconUp = new ImageIcon(iconUp);

        //Iconul pentru Folder
        iconDown = ComponentsUtils.createImage(ICON_DESC);
        imageIconDown = new ImageIcon(iconDown);
    }


    /**
     * Obtine iconul pentru handle
     * @param type      Tipul elementului
     * @return Iconul pentru element sau noIcon
     */
    public Icon getIcon(int type) {
        switch (type) {
            case ASC:
                return imageIconUp;
            case DESC:
                return imageIconDown;
            default:
                return noIcon;
        }
    }
}