package exenne.components.jdatepicker;

import exenne.components.jdatepicker.impl.JDatePanelImpl;
import exenne.components.jdatepicker.impl.JDatePickerImpl;
import exenne.components.jdatepicker.impl.SqlDateModel;
import exenne.components.jdatepicker.impl.UtilCalendarModel;
import exenne.components.jdatepicker.impl.UtilDateModel;
import javax.swing.JFormattedTextField;


/**
 * Created 18 April 2010
 * 
 * @author Juan Heyns
 */
public class JDateComponentFactory {
	
	/**
	 * Create with default model and formatter.
	 * 
	 * @return
	 */
	public static JDatePicker createJDatePicker() {
		return new JDatePickerImpl(new JDatePanelImpl(null), null);
	}
	
	/**
	 * Create with default formatter.
	 * 
	 * @return
	 */
	public static JDatePicker createJDatePicker(DateModel<?> model) {
		return new JDatePickerImpl(new JDatePanelImpl(model), null);
	}
	
	/**
	 * Create with default model.
	 * 
	 * @return
	 */
	public static JDatePicker createJDatePicker(JFormattedTextField.AbstractFormatter dateFormatter) {
		return new JDatePickerImpl(new JDatePanelImpl(null), dateFormatter);
	}
	
	/**
	 * Create specifying model and formatter.
	 * 
	 * @return
	 */
	public static JDatePicker createJDatePicker(DateModel<?> model, JFormattedTextField.AbstractFormatter dateFormatter) {
		return new JDatePickerImpl(new JDatePanelImpl(model), dateFormatter);
	}
	
	/**
	 * Create with default model.
	 * 
	 * @return
	 */
	public static JDatePanel createJDatePanel() {
		return new JDatePanelImpl(null);
	}
	
	/**
	 * Create specifying model.
	 * 
	 * @return
	 */
	public static JDatePanel createJDatePanel(DateModel<?> model) {
		return new JDatePanelImpl(model);
	}
	
	/**
	 * Create a DateModel based on the type of the value.
	 * 
	 * @param value
	 * @return
	 */
	public static DateModel<?> createDateModel(Object value) {
		Class<?> clazz = value.getClass();
		
		DateModel<?> result = null;
		if (clazz.equals(java.util.Calendar.class)) {
			result = new UtilCalendarModel((java.util.Calendar)value);
		}
		if (clazz.equals(java.util.Date.class)) {
			result = new UtilDateModel((java.util.Date)value);
		}
		if (clazz.equals(java.sql.Date.class)) {
			result = new SqlDateModel((java.sql.Date)value);
		}
		
		return result;
	}
	
	/**
	 * Create a DateModel initialised to today, based on the clazz type.
	 * 
	 * @param clazz
	 * @return
	 */
	public static DateModel<?> createDateModel(Class<?> clazz) {
		DateModel<?> result = null;
		if (clazz.equals(java.util.Calendar.class)) {
			result = new UtilCalendarModel();
		}
		if (clazz.equals(java.util.Date.class)) {
			result = new UtilDateModel();
		}
		if (clazz.equals(java.sql.Date.class)) {
			result = new SqlDateModel();
		}
		
		return result;
	}
	
}
