/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.popup;

import exenne.components.utils.ComponentsUtils;
import java.awt.*;
import javax.swing.*;

/**
 * Icon pentru TreeTable
 *
 * @author iulian
 */
public class JCopyPasteIcons  {
    public static final String ICON_CUT = "/exenne/components/popup/images/cut16.gif";
    public static final String ICON_COPY = "/exenne/components/popup/images/copy16.gif";
    public static final String ICON_PASTE = "/exenne/components/popup/images/paste16.gif";

    public static final int CUT = 0;
    public static final int COPY = 1;
    public static final int PASTE = 2;

    private Image iconCut;
    private Image iconCopy;
    private Image iconPaste;

    private ImageIcon imageIconCut;
    private ImageIcon imageIconCopy;
    private ImageIcon imageIconPaste;

    private Icon noIcon;

    public JCopyPasteIcons() {
        noIcon = null;
        loadIcons();
    }

    /**
     * Incarc imaginile pentru icoane
     */
    public void loadIcons() {
        //Iconul pentru Stare
        iconCut = ComponentsUtils.createImage(ICON_CUT);
        imageIconCut = new ImageIcon(iconCut);

        //Iconul pentru Stare
        iconCopy = ComponentsUtils.createImage(ICON_COPY);
        imageIconCopy = new ImageIcon(iconCopy);

        //Iconul pentru Folder
        iconPaste = ComponentsUtils.createImage(ICON_PASTE);
        imageIconPaste = new ImageIcon(iconPaste);
    }


    /**
     * Obtine iconul pentru handle
     * @param type      Tipul elementului
     * @return Iconul pentru element sau noIcon
     */
    public Icon getIcon(int type) {
        switch (type) {
            case CUT:
                return imageIconCut;
            case COPY:
                return imageIconCopy;
            case PASTE:
                return imageIconPaste;
            default:
                return noIcon;
        }
    }
}