/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.sidebar;

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

import exenne.components.utils.ComponentsUtils;
import java.awt.*;
import javax.swing.*;

/**
 * Icon pentru TreeTable
 *
 * @author iulian
 */
public class JSideBarIcons {
    public static final String ICON_LEFT = "/exenne/components/sidebar/images/arrow_left24.gif";
    public static final String ICON_RIGHT = "/exenne/components/sidebar/images/arrow_right24.gif";
    public static final String ICON_UP = "/exenne/components/sidebar/images/arrow_up24.gif";
    public static final String ICON_DOWN = "/exenne/components/sidebar/images/arrow_down24.gif";

    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int UP = 2;
    public static final int DOWN = 3;

    //icoane pentru sidebar
    private static Image iconLeft;
    private static Image iconRight;
    private static Image iconUp;
    private static Image iconDown;

    private static ImageIcon imageIconLeft;
    private static ImageIcon imageIconRight;
    private static ImageIcon imageIconUp;
    private static ImageIcon imageIconDown;

    private Icon noIcon;

    public JSideBarIcons() {
        noIcon = null;
        loadIcons();
    }

    /**
     * Incarc imaginile pentru icoane
     */
    public void loadIcons() {
        //Iconul pentru Stare
        iconLeft = ComponentsUtils.createImage(ICON_LEFT);
        imageIconLeft = new ImageIcon(iconLeft);
        //Iconul pentru Folder
        iconRight = ComponentsUtils.createImage(ICON_RIGHT);
        imageIconRight = new ImageIcon(iconRight);
        //Iconul pentru Folder opened
        iconUp = ComponentsUtils.createImage(ICON_UP);
        imageIconUp = new ImageIcon(iconUp);
        //Iconul pentru Investitie
        iconDown = ComponentsUtils.createImage(ICON_DOWN);
        imageIconDown = new ImageIcon(iconDown);
    }

    /**
     * Obtine iconul pentru obiectul specificat
     * @param type Tipul obiectului
     * @return Iconul pentru obiect sau noIcon
     */
    public Icon getIcon(int type) {
        return getIcon(type, false);
    }

    /**
     * Obtine iconul pentru elementul specificat
     * @param type      Tipul elementului
     * @param isExpanded Daca este expanded
     * @return Iconul pentru element sau noIcon
     */
    public Icon getIcon(int type, boolean isOpened) {
        switch (type) {
            case (LEFT):
                return imageIconLeft;
            case (RIGHT):
                return imageIconRight;
            case (DOWN):
                return imageIconDown;
            case (UP):
                return imageIconUp;
            default:
                return noIcon;
        }
    }
}