/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.treetable.cellrenderers;

import java.awt.Component;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.SwingConstants;
import javax.swing.border.Border;

/**
 *
 * @author iulian
 */
public class ExpansionHandleBorder implements  Border {
    private Insets insets = new Insets(0, 0, 0, 0);

    public Insets getBorderInsets(Component c) {
        AbstractTreetableCellRenderer ren = (AbstractTreetableCellRenderer) c;
        if (ren.isShowHandle()) {
            /**
             * Creez caz special pentur root si
             * shiftez totul la stanga pastrand identarea
             */
            if (ren.getNestingDepth() == 0) insets.left = 1;
            else insets.left = ren.getExpansionHandleWidth()
                    + ((ren.getNestingDepth()-1) * ren.getNestingWidth());
            //Defensively adjust all the insets fields
            insets.top = 0;
            insets.right = 5;
            insets.bottom = 0;
        } else {
            //Defensively adjust all the insets fields
            int halignment = ren.getHorizontalAlignment();
            if (halignment == SwingConstants.RIGHT) {
                insets.left = 0;
                insets.top = 0;
                insets.right = 5;
                insets.bottom = 0;
            } else {
                insets.left = 0;
                insets.top = 0;
                insets.right = 0;
                insets.bottom = 0;
            }
        }
        return insets;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public void paintBorder(Component c, java.awt.Graphics g,
            int x, int y, int width, int height) {
        AbstractTreetableCellRenderer ren = (AbstractTreetableCellRenderer) c;
        if (ren.isShowHandle() && !ren.isLeaf()) {
            Icon icon = ren.isExpanded() ? ren.getExpandedIcon()
                    : ren.getCollapsedIcon();
            int iconY,iconX;
            //Caz special pentru root ca sa nu treaca pe negativ
            if (ren.getNestingDepth() == 0) iconX = 0;
            else iconX = (ren.getNestingDepth()-1) * ren.getNestingWidth();
            if (icon.getIconHeight() < height) {
                iconY = (height / 2) - (icon.getIconHeight() / 2);
            } else {
                iconY = 0;
            }
            icon.paintIcon(c, g, iconX, iconY);
        }
    }
}
