/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.treetable.undosupport;

import exenne.components.treetable.Treetable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

/**
 *
 * @author iulian
 */
public class PropertyStandardUndoableEdit extends AbstractUndoableEdit {
    //Eveniment de proprietati
    private ActionEvent someAction =
            new ActionEvent(this, 0, "PropertyStandardUndoableEdit");

    //Editarea unei valori in controller
    private Treetable treetable;
    private DefaultMutableTreeNode targetNode;
    private UndoableEdit controllerAction;

    //Ascultatorul de actiune
    private ActionListener actionListener;

    /**
     * Construieste o actiune de undo
     * @param targetNodes
     * @param controllerAction
     */
    public PropertyStandardUndoableEdit(Treetable treetable,
            DefaultMutableTreeNode targetNode,
            UndoableEdit controllerAction, 
            ActionListener actionListener) {
        this.treetable = treetable;
        this.targetNode = targetNode;
        this.controllerAction = controllerAction;
        this.actionListener = actionListener;
    }

    /**
     * Operatia de undo
     * @throws CannotUndoException
     */
    @Override
    public void undo() throws CannotUndoException {
        super.undo();

        //1. Anulez actiunea din controller
        controllerAction.undo();

        //2. Fac selectia nodului care s-a modificat
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode) targetNode.getParent();
        if (parentNode != null) {
            treetable.clearSelection();
            treetable.expandNode(parentNode);
            treetable.selectAndScrollToNode(targetNode);
        }

        //3. Notific modificarea pretului
        if (actionListener != null)
            actionListener.actionPerformed(someAction);
    }

    /**
     * Operatia de redo
     * @throws CannotRedoException
     */
    @Override
    public void redo() throws CannotRedoException {
        super.redo();

        //1. Refac acctiunea din controller
        controllerAction.redo();

        //2. Fac selectia nodului care s-a modificat
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode) targetNode.getParent();
        if (parentNode != null) {
            treetable.clearSelection();
            treetable.expandNode(parentNode);
            treetable.selectAndScrollToNode(targetNode);
        }

        //3. Notific modificarea pretului
        if (actionListener != null)
            actionListener.actionPerformed(someAction);
    }
}
