/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package exenne.components.treetable.warningrowbar;

import exenne.components.utils.ComponentsUtils;
import java.awt.*;
import javax.swing.*;

/**
 * Icon pentru TreeTable
 *
 * @author iulian
 */
public class JWarningBarIcons {
    //Il fac singleton
    private static JWarningBarIcons instance = null;
    
    public static final String ICON_WARNING = "/exenne/components/treetable/warningrowbar/images/warning16.gif";
    public static final String ICON_FATAL = "/exenne/components/treetable/warningrowbar/images/fatal16.gif";
    public static final String ICON_WARNING_SUGGESTION = "/exenne/components/treetable/warningrowbar/images/warning_suggestion16.gif";
    public static final String ICON_FATAL_SUGGESTION = "/exenne/components/treetable/warningrowbar/images/fatal_suggestion16.gif";
    
    public static final int WARNING = 0;
    public static final int FATAL = 1;
    public static final int WARNING_SUGGESTION = 2;
    public static final int FATAL_SUGGESTION = 4;

    private Image iconWarning;
    private Image iconFatal;
    private Image iconWarningSuggestion;
    private Image iconFatalSuggestion;

    private ImageIcon imageIconWarning;
    private ImageIcon imageIconFatal;
    private ImageIcon imageIconWarningSuggestion;
    private ImageIcon imageIconFatalSuggestion;

    private Icon noIcon;

    private JWarningBarIcons() {
        noIcon = null;
        loadIcons();
    }

    /**
     * Metoda de obtinere clasa
     * @return 
     */
    public static JWarningBarIcons getInstance() {
        if (instance == null)
            instance = new JWarningBarIcons();
        
        return instance;
    }
    
    
    /**
     * Incarc imaginile pentru icoane
     */
    public void loadIcons() {
        //Icon
        iconWarning = ComponentsUtils.createImage(ICON_WARNING);
        imageIconWarning = new ImageIcon(iconWarning);

        //Icon
        iconFatal = ComponentsUtils.createImage(ICON_FATAL);
        imageIconFatal = new ImageIcon(iconFatal);

        //Icon
        iconWarningSuggestion = ComponentsUtils.createImage(ICON_WARNING_SUGGESTION);
        imageIconWarningSuggestion = new ImageIcon(iconWarningSuggestion);
        
        //Icon
        iconFatalSuggestion = ComponentsUtils.createImage(ICON_FATAL_SUGGESTION);
        imageIconFatalSuggestion = new ImageIcon(iconFatalSuggestion);
    }

    /**
     * Obtine iconul pentru handle
     * @param type      Tipul elementului
     * @return Iconul pentru element sau noIcon
     */
    public Icon getIcon(int type) {
        switch (type) {
            case WARNING:
                return imageIconWarning;
            case FATAL:
                return imageIconFatal;
            case WARNING_SUGGESTION:
                return imageIconWarningSuggestion;
            case FATAL_SUGGESTION:
                return imageIconFatalSuggestion;
            default:
                return noIcon;
        }
    }
}