/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.components.jtable.tooltiplauncher;

import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.ToolTipManager;

public class JTooltipLauncherMouseListener
extends MouseAdapter {
    private int targetedColumn;
    private int iconLocation;
    private static final int ICON_SIZE = 24;

    public JTooltipLauncherMouseListener(int column) {
        this(column, 4);
    }

    public JTooltipLauncherMouseListener(int column, int iconLocation) {
        this.targetedColumn = column;
        this.iconLocation = iconLocation;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        if (e.getSource() instanceof JTable && e.getButton() == 1) {
            JTable table = (JTable)e.getSource();
            int row = table.rowAtPoint(e.getPoint());
            int col = table.columnAtPoint(e.getPoint());
            if (row != -1 && col == this.targetedColumn) {
                int x_difference;
                Rectangle rect = table.getCellRect(row, col, false);
                switch (this.iconLocation) {
                    case 4: {
                        x_difference = (int)(rect.getX() + rect.getWidth() - (double)e.getX());
                        break;
                    }
                    case 2: {
                        x_difference = (int)((double)e.getX() - rect.getX());
                        break;
                    }
                    default: {
                        x_difference = 0;
                    }
                }
                if (x_difference < 24) {
                    MouseEvent myMouseEvent = new MouseEvent(table, 0, 0L, 0, e.getX(), e.getY(), 0, false);
                    int initialDelay = ToolTipManager.sharedInstance().getInitialDelay();
                    ToolTipManager.sharedInstance().setInitialDelay(0);
                    ToolTipManager.sharedInstance().mouseMoved(myMouseEvent);
                    ToolTipManager.sharedInstance().setInitialDelay(initialDelay);
                }
            }
        }
    }
}

