/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.components.propertiespanel.editors;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import ro.genomeartist.components.icons.JColorIcon;
import ro.genomeartist.components.propertiespanel.IEditorChangeListener;
import ro.genomeartist.components.propertiespanel.IPropertiesEditor;
import ro.genomeartist.components.propertiespanel.undecided.UndecidedColor;

public class JColorChooserPropertiesEditor
extends JPanel
implements IPropertiesEditor,
ActionListener {
    private Vector<IEditorChangeListener> editorChangeListeners;
    private JButton colorButton;
    private JColorIcon colorIcon;
    private JColorChooser colorChooser;
    private boolean isUndecided = false;

    public JColorChooserPropertiesEditor() {
        this.setLayout(new BorderLayout());
        this.colorButton = new JButton();
        this.colorIcon = new JColorIcon(Color.black);
        this.colorChooser = new JColorChooser();
        this.colorButton.setIcon(this.colorIcon);
        this.colorButton.setHorizontalAlignment(0);
        this.colorButton.setBorderPainted(false);
        this.colorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JColorChooserPropertiesEditor.this.colorChooser.setColor(JColorChooserPropertiesEditor.this.colorIcon.getColor());
                JDialog dialog = JColorChooser.createDialog(JColorChooserPropertiesEditor.this, "Pick a Color", true, JColorChooserPropertiesEditor.this.colorChooser, JColorChooserPropertiesEditor.this, null);
                dialog.setVisible(true);
            }
        });
        this.add((Component)this.colorButton, "Center");
        this.editorChangeListeners = new Vector();
    }

    @Override
    public JComponent getContainerComponent() {
        return this;
    }

    @Override
    public JComponent getEditorComponent() {
        return this.colorButton;
    }

    @Override
    public void setEditorName(String name) {
        this.setName(name);
    }

    @Override
    public void setValue(Class objectClass, Object renderedObject) {
        if (Color.class == objectClass) {
            Color auxColor = (Color)renderedObject;
            this.colorIcon.setColor(auxColor);
        } else if (UndecidedColor.class == objectClass) {
            Color auxColor;
            UndecidedColor auxUndecidedColor = (UndecidedColor)renderedObject;
            if (auxUndecidedColor.isDecided()) {
                auxColor = auxUndecidedColor.getColor();
            } else {
                auxColor = Color.BLACK;
                this.setUndecided(true);
            }
            this.colorIcon.setColor(auxColor);
        } else {
            throw new UnsupportedOperationException(objectClass + " not supported in JColorIcon");
        }
    }

    private void setUndecided(boolean isUndecided) {
        if (this.isUndecided != isUndecided) {
            this.isUndecided = isUndecided;
            if (this.isUndecided) {
                this.colorButton.setIcon(null);
                this.colorButton.setText("<valori diferite>");
            } else {
                this.colorButton.setIcon(this.colorIcon);
                this.colorButton.setText("");
            }
        }
    }

    @Override
    public Object getValue(Class objectClass) {
        if (Color.class == objectClass) {
            Color auxColor = this.colorIcon.getColor();
            return auxColor;
        }
        if (UndecidedColor.class == objectClass) {
            Color auxColor = this.colorIcon.getColor();
            return new UndecidedColor(auxColor, this.isUndecided);
        }
        throw new UnsupportedOperationException(objectClass + " not supported in JColorIcon");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.colorIcon.setColor(this.colorChooser.getColor());
        this.setUndecided(false);
        for (IEditorChangeListener iEditorChangeListener : this.editorChangeListeners) {
            iEditorChangeListener.fireValueChanged();
        }
    }

    @Override
    public void addEditorChangeListener(IEditorChangeListener listener) {
        this.editorChangeListeners.add(listener);
    }

    @Override
    public void removeEditorChangeListener(IEditorChangeListener listener) {
        this.editorChangeListeners.remove(listener);
    }
}

