/*
 * Decompiled with CFR 0.152.
 */
package ro.genomeartist.components.tabbedpane;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import ro.genomeartist.components.tabbedpane.INeedCleanup;
import ro.genomeartist.components.tabbedpane.JComponentForTab;
import ro.genomeartist.components.tabbedpane.TabSpecifications;

public class JDragableTabbedPane
extends JTabbedPane {
    private static final int LINEWIDTH = 3;
    private static final String NAME = "test";
    private final GhostGlassPane glassPane = new GhostGlassPane();
    private final Rectangle lineRect = new Rectangle();
    private final Color lineColor = new Color(0, 100, 255);
    private int dragTabIndex = -1;
    private static Rectangle rBackward = new Rectangle();
    private static Rectangle rForward = new Rectangle();
    private static int rwh = 20;
    private static int buttonsize = 30;
    private boolean hasGhost = true;

    public JDragableTabbedPane() {
        this.setTabLayoutPolicy(1);
        this.setFocusable(false);
        final DragSourceListener dsl = new DragSourceListener(){

            @Override
            public void dragEnter(DragSourceDragEvent e) {
                e.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
            }

            @Override
            public void dragExit(DragSourceEvent e) {
                e.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
                JDragableTabbedPane.this.lineRect.setRect(0.0, 0.0, 0.0, 0.0);
                JDragableTabbedPane.this.glassPane.setPoint(new Point(-1000, -1000));
                JDragableTabbedPane.this.glassPane.repaint();
            }

            @Override
            public void dragOver(DragSourceDragEvent e) {
                Point glassPt = e.getLocation();
                SwingUtilities.convertPointFromScreen(glassPt, JDragableTabbedPane.this.glassPane);
                int targetIdx = JDragableTabbedPane.this.getDNDTargetTabIndex(glassPt);
                if (JDragableTabbedPane.this.getTabAreaBounds().contains(glassPt) && targetIdx >= 0 && targetIdx != JDragableTabbedPane.this.dragTabIndex && targetIdx != JDragableTabbedPane.this.dragTabIndex + 1) {
                    e.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
                } else {
                    e.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
                }
            }

            @Override
            public void dragDropEnd(DragSourceDropEvent e) {
                JDragableTabbedPane.this.lineRect.setRect(0.0, 0.0, 0.0, 0.0);
                JDragableTabbedPane.this.dragTabIndex = -1;
                JDragableTabbedPane.this.glassPane.setVisible(false);
                if (JDragableTabbedPane.this.hasGhost()) {
                    JDragableTabbedPane.this.glassPane.setVisible(false);
                    JDragableTabbedPane.this.glassPane.setImage(null);
                }
            }

            @Override
            public void dropActionChanged(DragSourceDragEvent e) {
            }
        };
        final Transferable t = new Transferable(){
            private final DataFlavor FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref", "test");

            @Override
            public Object getTransferData(DataFlavor flavor) {
                return "phony transferable";
            }

            @Override
            public DataFlavor[] getTransferDataFlavors() {
                DataFlavor[] f = new DataFlavor[]{this.FLAVOR};
                return f;
            }

            @Override
            public boolean isDataFlavorSupported(DataFlavor flavor) {
                return flavor.getHumanPresentableName().equals(JDragableTabbedPane.NAME);
            }
        };
        DragGestureListener dgl = new DragGestureListener(){

            @Override
            public void dragGestureRecognized(DragGestureEvent e) {
                if (JDragableTabbedPane.this.getTabCount() <= 1) {
                    return;
                }
                Point tabPt = e.getDragOrigin();
                JDragableTabbedPane.this.dragTabIndex = JDragableTabbedPane.this.indexAtLocation(tabPt.x, tabPt.y);
                if (JDragableTabbedPane.this.dragTabIndex < 0 || !JDragableTabbedPane.this.isEnabledAt(JDragableTabbedPane.this.dragTabIndex)) {
                    return;
                }
                JDragableTabbedPane.this.initGlassPane(e.getComponent(), e.getDragOrigin());
                try {
                    e.startDrag(DragSource.DefaultMoveDrop, t, dsl);
                }
                catch (InvalidDnDOperationException idoe) {
                    idoe.printStackTrace();
                }
            }
        };
        new DropTarget(this.glassPane, 3, new CDropTargetListener(), true);
        new DragSource().createDefaultDragGestureRecognizer(this, 3, dgl);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int tab;
                if (e.getButton() == 2 && (tab = JDragableTabbedPane.this.getTabAtPoint(e.getPoint())) != -1) {
                    Component component = JDragableTabbedPane.this.getComponentAt(tab);
                    if (tab != -1) {
                        JDragableTabbedPane.this.remove(tab);
                        if (component instanceof INeedCleanup) {
                            ((INeedCleanup)((Object)component)).cleanup();
                        }
                        e.consume();
                    }
                }
            }
        });
    }

    @Override
    public Component add(Component component) {
        return this.add(component.getName(), component);
    }

    @Override
    public void add(Component component, Object constraints) {
        this.add(component);
    }

    @Override
    public Component add(Component component, int index) {
        return this.add(component.getName(), component, index);
    }

    @Override
    public void add(Component component, Object constraints, int index) {
        this.add(component, index);
    }

    public Component add(String title, Component component, int index) {
        TabSpecifications specifications = new TabSpecifications();
        specifications.title = title;
        return this.add(specifications, component, index);
    }

    @Override
    public Component add(String title, Component component) {
        TabSpecifications specifications = new TabSpecifications();
        specifications.title = title;
        return this.add(specifications, component);
    }

    public Component add(TabSpecifications specifications, Component component, int index) {
        super.add(component, index);
        int i = this.indexOfComponent(component);
        if (i != -1) {
            JComponentForTab componentForTab = new JComponentForTab(specifications.icon, specifications.title, this, specifications.shouldBeBold);
            this.setTabComponentAt(i, componentForTab);
        }
        return component;
    }

    public Component add(TabSpecifications specifications, Component component) {
        super.add(specifications.title, component);
        int i = this.indexOfComponent(component);
        if (i != -1) {
            JComponentForTab componentForTab = new JComponentForTab(specifications.icon, specifications.title, this, specifications.shouldBeBold);
            this.setTabComponentAt(i, componentForTab);
        }
        return component;
    }

    @Override
    public void setTitleAt(int index, String title) {
        super.setTitleAt(index, title);
        JComponentForTab tabComponent = (JComponentForTab)this.getTabComponentAt(index);
        tabComponent.setTitle(title);
    }

    @Override
    public void setIconAt(int index, Icon icon) {
        super.setIconAt(index, icon);
        JComponentForTab tabComponent = (JComponentForTab)this.getTabComponentAt(index);
        tabComponent.setIcon(icon);
    }

    public void setTextBoldAt(int index, boolean shouldBeBold) {
        JComponentForTab tabComponent = (JComponentForTab)this.getTabComponentAt(index);
        tabComponent.setTextBold(shouldBeBold);
    }

    private void autoScrollTest(Point glassPt) {
        Rectangle r = this.getTabAreaBounds();
        int tabPPlacement = this.getTabPlacement();
        if (tabPPlacement == 1 || tabPPlacement == 3) {
            rBackward.setBounds(r.x, r.y, rwh, r.height);
            rForward.setBounds(r.x + r.width - rwh - buttonsize, r.y, rwh + buttonsize, r.height);
        } else if (tabPPlacement == 2 || tabPPlacement == 4) {
            rBackward.setBounds(r.x, r.y, r.width, rwh);
            rForward.setBounds(r.x, r.y + r.height - rwh - buttonsize, r.width, rwh + buttonsize);
        }
        if (rBackward.contains(glassPt)) {
            this.clickArrowButton("scrollTabsBackwardAction");
        } else if (rForward.contains(glassPt)) {
            this.clickArrowButton("scrollTabsForwardAction");
        }
    }

    private void clickArrowButton(String actionKey) {
        Action action;
        ActionMap map = this.getActionMap();
        if (map != null && (action = map.get(actionKey)) != null && action.isEnabled()) {
            action.actionPerformed(new ActionEvent(this, 1001, null, 0L, 0));
        }
    }

    private int getTabAtPoint(Point p) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            Rectangle r = this.getBoundsAt(i);
            if (!r.contains(p)) continue;
            return i;
        }
        return -1;
    }

    public void setPaintGhost(boolean flag) {
        this.hasGhost = flag;
    }

    public boolean hasGhost() {
        return this.hasGhost;
    }

    private int getDNDTargetTabIndex(Point glassPt) {
        Point tabPt = SwingUtilities.convertPoint(this.glassPane, glassPt, this);
        boolean isTB = this.getTabPlacement() == 1 || this.getTabPlacement() == 3;
        for (int i = 0; i < this.getTabCount(); ++i) {
            Rectangle r = this.getBoundsAt(i);
            if (isTB) {
                r.setRect(r.x - r.width / 2, r.y, r.width, r.height);
            } else {
                r.setRect(r.x, r.y - r.height / 2, r.width, r.height);
            }
            if (!r.contains(tabPt)) continue;
            return i;
        }
        Rectangle r = this.getBoundsAt(this.getTabCount() - 1);
        if (isTB) {
            r.setRect(r.x + r.width / 2, r.y, r.width, r.height);
        } else {
            r.setRect(r.x, r.y + r.height / 2, r.width, r.height);
        }
        return r.contains(tabPt) ? this.getTabCount() : -1;
    }

    private void convertTab(int prev, int next) {
        if (next < 0 || prev == next) {
            return;
        }
        Component cmp = this.getComponentAt(prev);
        Component tab = this.getTabComponentAt(prev);
        String str = this.getTitleAt(prev);
        Icon icon = this.getIconAt(prev);
        String tip = this.getToolTipTextAt(prev);
        boolean flg = this.isEnabledAt(prev);
        int tgtindex = prev > next ? next : next - 1;
        this.remove(prev);
        this.insertTab(str, icon, cmp, tip, tgtindex);
        this.setEnabledAt(tgtindex, flg);
        if (flg) {
            this.setSelectedIndex(tgtindex);
        }
        this.setTabComponentAt(tgtindex, tab);
    }

    private void initTargetLeftRightLine(int next) {
        if (next < 0 || this.dragTabIndex == next || next - this.dragTabIndex == 1) {
            this.lineRect.setRect(0.0, 0.0, 0.0, 0.0);
        } else if (next == 0) {
            Rectangle r = SwingUtilities.convertRectangle(this, this.getBoundsAt(0), this.glassPane);
            this.lineRect.setRect(r.x - 1, r.y, 3.0, r.height);
        } else {
            Rectangle r = SwingUtilities.convertRectangle(this, this.getBoundsAt(next - 1), this.glassPane);
            this.lineRect.setRect(r.x + r.width - 1, r.y, 3.0, r.height);
        }
    }

    private void initTargetTopBottomLine(int next) {
        if (next < 0 || this.dragTabIndex == next || next - this.dragTabIndex == 1) {
            this.lineRect.setRect(0.0, 0.0, 0.0, 0.0);
        } else if (next == 0) {
            Rectangle r = SwingUtilities.convertRectangle(this, this.getBoundsAt(0), this.glassPane);
            this.lineRect.setRect(r.x, r.y - 1, r.width, 3.0);
        } else {
            Rectangle r = SwingUtilities.convertRectangle(this, this.getBoundsAt(next - 1), this.glassPane);
            this.lineRect.setRect(r.x, r.y + r.height - 1, r.width, 3.0);
        }
    }

    private void initGlassPane(Component c, Point tabPt) {
        this.getRootPane().setGlassPane(this.glassPane);
        if (this.hasGhost()) {
            Rectangle rect = this.getBoundsAt(this.dragTabIndex);
            BufferedImage image = new BufferedImage(c.getWidth(), c.getHeight(), 2);
            Graphics g = image.getGraphics();
            c.paint(g);
            rect.x = rect.x < 0 ? 0 : rect.x;
            rect.y = rect.y < 0 ? 0 : rect.y;
            image = image.getSubimage(rect.x, rect.y, rect.width, rect.height);
            this.glassPane.setImage(image);
        }
        Point glassPt = SwingUtilities.convertPoint(c, tabPt, this.glassPane);
        this.glassPane.setPoint(glassPt);
        this.glassPane.setVisible(true);
    }

    private Rectangle getTabAreaBounds() {
        Rectangle tabbedRect = this.getBounds();
        Rectangle scr = this.getSelectedComponent().getBounds();
        int tabPPlacement = this.getTabPlacement();
        if (tabPPlacement == 1) {
            tabbedRect.height -= scr.height;
        } else if (tabPPlacement == 3) {
            tabbedRect.y = tabbedRect.y + scr.y + scr.height;
            tabbedRect.height -= scr.height;
        } else if (tabPPlacement == 2) {
            tabbedRect.width -= scr.width;
        } else if (tabPPlacement == 4) {
            tabbedRect.x = tabbedRect.x + scr.x + scr.width;
            tabbedRect.width -= scr.width;
        }
        tabbedRect.grow(2, 2);
        return tabbedRect;
    }

    class GhostGlassPane
    extends JPanel {
        private final AlphaComposite composite;
        private Point location = new Point(0, 0);
        private BufferedImage draggingGhost = null;
        boolean debug = false;

        public GhostGlassPane() {
            this.setOpaque(false);
            this.composite = AlphaComposite.getInstance(3, 0.5f);
            this.setCursor(null);
        }

        public void setImage(BufferedImage draggingGhost) {
            this.draggingGhost = draggingGhost;
        }

        public void setPoint(Point location) {
            this.location = location;
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setComposite(this.composite);
            if (this.debug && JDragableTabbedPane.this.getTabLayoutPolicy() == 1) {
                g2.setPaint(Color.RED);
                g2.fill(rBackward);
                g2.fill(rForward);
            }
            if (this.draggingGhost != null) {
                double xx = this.location.getX() - (double)this.draggingGhost.getWidth(this) / 2.0;
                double yy = this.location.getY() - (double)this.draggingGhost.getHeight(this) / 2.0;
                g2.drawImage((Image)this.draggingGhost, (int)xx, (int)yy, null);
            }
            if (JDragableTabbedPane.this.dragTabIndex >= 0) {
                g2.setPaint(JDragableTabbedPane.this.lineColor);
                g2.fill(JDragableTabbedPane.this.lineRect);
            }
        }
    }

    class CDropTargetListener
    implements DropTargetListener {
        private Point pt_ = new Point();

        CDropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            if (this.isDragAcceptable(e)) {
                e.acceptDrag(e.getDropAction());
            } else {
                e.rejectDrag();
            }
        }

        @Override
        public void dragExit(DropTargetEvent e) {
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            Point pt = e.getLocation();
            if (JDragableTabbedPane.this.getTabPlacement() == 1 || JDragableTabbedPane.this.getTabPlacement() == 3) {
                JDragableTabbedPane.this.initTargetLeftRightLine(JDragableTabbedPane.this.getDNDTargetTabIndex(pt));
            } else {
                JDragableTabbedPane.this.initTargetTopBottomLine(JDragableTabbedPane.this.getDNDTargetTabIndex(pt));
            }
            if (JDragableTabbedPane.this.hasGhost()) {
                JDragableTabbedPane.this.glassPane.setPoint(pt);
            }
            if (!this.pt_.equals(pt)) {
                JDragableTabbedPane.this.glassPane.repaint();
            }
            this.pt_ = pt;
            JDragableTabbedPane.this.autoScrollTest(pt);
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            if (this.isDropAcceptable(e)) {
                JDragableTabbedPane.this.convertTab(JDragableTabbedPane.this.dragTabIndex, JDragableTabbedPane.this.getDNDTargetTabIndex(e.getLocation()));
                e.dropComplete(true);
            } else {
                e.dropComplete(false);
            }
            JDragableTabbedPane.this.repaint();
        }

        public boolean isDragAcceptable(DropTargetDragEvent e) {
            Transferable t = e.getTransferable();
            if (t == null) {
                return false;
            }
            DataFlavor[] f = e.getCurrentDataFlavors();
            return t.isDataFlavorSupported(f[0]) && JDragableTabbedPane.this.dragTabIndex >= 0;
        }

        public boolean isDropAcceptable(DropTargetDropEvent e) {
            Transferable t = e.getTransferable();
            if (t == null) {
                return false;
            }
            DataFlavor[] f = t.getTransferDataFlavors();
            return t.isDataFlavorSupported(f[0]) && JDragableTabbedPane.this.dragTabIndex >= 0;
        }
    }
}

